/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.db.ColGroup;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.FunctionEnd;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.dml.SearchedCase;
import com.github.quintans.ezSQL.dml.SimpleCase;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Definition {
    public static ColGroup ASSOCIATE(Column<?> ... from) {
        if (Misc.length(from) > 0) {
            Table table = from[0].getTable();
            for (Column<?> source : from) {
                if (table.equals(source.getTable())) continue;
                throw new PersistenceException("All columns must belong to the same table");
            }
            return new ColGroup(from);
        }
        return null;
    }

    public static Condition or(List<Condition> operations) {
        if (operations.size() == 1) {
            return operations.get(0);
        }
        return Definition.or(operations.toArray(new Condition[0]));
    }

    public static Condition or(Condition ... operations) {
        if (operations.length == 1) {
            return operations[0];
        }
        return new Condition("OR", operations);
    }

    public static Condition and(List<Condition> operations) {
        if (operations.size() == 1) {
            return operations.get(0);
        }
        return Definition.and(operations.toArray(new Condition[0]));
    }

    public static Condition and(Condition ... operations) {
        if (operations.length == 1) {
            return operations[0];
        }
        return new Condition("AND", operations);
    }

    public static Condition greater(Object column, Object value) {
        return new Condition("GT", column, value);
    }

    public static Condition greaterOrMatch(Object column, Object value) {
        return new Condition("GTEQ", column, value);
    }

    public static Condition lesser(Object column, Object value) {
        return new Condition("LT", column, value);
    }

    public static Condition lesserOrMatch(Object column, Object value) {
        return new Condition("LTEQ", column, value);
    }

    public static Condition is(Object left, Object right) {
        return new Condition("EQ", left, right);
    }

    public static Condition range(Object column, Object bottom, Object top) {
        if (bottom != null && top != null) {
            return new Condition("RANGE", column, bottom, top);
        }
        if (bottom != null) {
            return Definition.greaterOrMatch(column, bottom);
        }
        if (top != null) {
            return Definition.lesserOrMatch(column, top);
        }
        throw new PersistenceException("Invalid Range Function");
    }

    public static Condition valueRange(Object bottom, Object top, Object value) {
        return new Condition("VALUERANGE", bottom, top, value);
    }

    public static Condition boundedRange(Object bottom, Object top, Object value) {
        return new Condition("BOUNDEDRANGE", bottom, top, value);
    }

    public static Condition isNull(Object column) {
        return new Condition("ISNULL", column);
    }

    public static Condition in(Object column, Collection<?> values) {
        ArrayList<Object> vals = new ArrayList<Object>(values.size() + 1);
        vals.add(column);
        vals.addAll(values);
        return new Condition("IN", vals.toArray(new Object[vals.size()]));
    }

    public static Condition in(Object column, Object ... value) {
        Object[] fs = new Object[value.length + 1];
        fs[0] = column;
        System.arraycopy(value, 0, fs, 1, value.length);
        return new Condition("IN", fs);
    }

    public static Condition iMatches(Object left, Object right) {
        return new Condition("IEQ", left, right);
    }

    public static Condition like(Object left, Object right) {
        return new Condition("LIKE", left, right);
    }

    public static Condition iLike(Object left, Object right) {
        return new Condition("ILIKE", left, right);
    }

    public static Condition different(Object left, Object right) {
        return new Condition("NEQ", left, right);
    }

    public static Condition exists(Object o) {
        return new Condition("EXISTS", o);
    }

    public static Condition not(Object o) {
        return new Condition("NOT", o);
    }

    public static Function param(String o) {
        return new FunctionEnd("PARAM", (Object)o);
    }

    public static Function param(Column<?> c) {
        return new FunctionEnd("PARAM", (Object)c.getAlias());
    }

    public static Function raw(Object o) {
        return new FunctionEnd("RAW", o);
    }

    public static Function asIs(Object o) {
        return new FunctionEnd("VAL", o);
    }

    public static Function as(String o) {
        return new FunctionEnd("ALIAS", (Object)o);
    }

    public static Function sum(Object o) {
        return new Function("SUM", o);
    }

    public static Function max(Object o) {
        return new Function("MAX", o);
    }

    public static Function min(Object o) {
        return new Function("MIN", o);
    }

    public static Function count() {
        return new Function("COUNT", new Object[0]);
    }

    public static Function count(Object o) {
        return new Function("COUNT", o);
    }

    public static Function rtrim(Object o) {
        return new Function("RTRIM", o);
    }

    public static Function now() {
        return new FunctionEnd("NOW", (Object)null);
    }

    public static Function add(Object ... o) {
        return new Function("ADD", o);
    }

    public static Function minus(Object ... o) {
        return new Function("MINUS", o);
    }

    public static Function multiply(Object ... o) {
        return new Function("MULTIPLY", o);
    }

    public static Function secondsdiff(Object ... o) {
        return new Function("SECONDSDIFF", o);
    }

    public static <T extends Number> Function autoNumber(Column<T> o) {
        return new Function("AUTONUM", o);
    }

    public static Function subQuery(Query inner) {
        return new FunctionEnd("SUBQUERY", (Object)inner);
    }

    public static Function upper(Object o) {
        return new Function("UPPER", o);
    }

    public static Function lower(Object o) {
        return new Function("LOWER", o);
    }

    public static Function coalesc(Object ... o) {
        return new Function("COALESCE", o);
    }

    public static SearchedCase.SearchedWhen when(Condition criteria) {
        return new SearchedCase().when(criteria);
    }

    public static SimpleCase with(Object expression) {
        return new SimpleCase(expression);
    }
}

