/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.common.api.Value;
import com.github.quintans.ezSQL.db.Association;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Discriminator;
import com.github.quintans.ezSQL.db.Relation;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.AliasBag;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Join;
import com.github.quintans.ezSQL.dml.PathElement;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.RawSql;
import com.github.quintans.jdbc.SimpleJdbc;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class DmlBase {
    protected AbstractDb db;
    protected SimpleJdbc simpleJdbc;
    protected Table table;
    protected String tableAlias;
    protected List<Join> joins;
    protected Condition condition;
    protected Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    public static final String JOIN_PREFIX = "j";
    protected AliasBag joinBag = new AliasBag("j");
    protected static final String PREFIX = "t";
    protected String lastFkAlias = null;
    protected Join lastJoin = null;
    protected RawSql rawSql;
    protected List<Condition> discriminatorConditions = null;
    private int rawIndex = 0;
    protected List<PathElement> path = null;
    protected List<PathElement[]> cachedAssociation = new ArrayList<PathElement[]>();

    public int nextRawIndex() {
        return ++this.rawIndex;
    }

    public DmlBase(AbstractDb db, Table table) {
        List<Condition> conditions;
        this.db = db;
        this.simpleJdbc = new SimpleJdbc(db.getJdbcSession());
        this.table = table;
        this.tableAlias = "t0";
        if (table != null && (conditions = table.getConditions()) != null) {
            this.discriminatorConditions = new ArrayList<Condition>(conditions);
            this.applyWhere(null);
        }
    }

    public AbstractDb getDb() {
        return this.db;
    }

    public Table getTable() {
        return this.table;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String alias) {
        this.tableAlias = alias;
        this.rawSql = null;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Object getParameter(Column<?> column) {
        return this.parameters.get(column.getAlias());
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setParameter(Column<?> col, Object value) {
        String name = col.getAlias();
        if (value == null) {
            value = col.getType();
        }
        this.setParameter(name, value);
    }

    public void setParameter(String name, Object value) {
        if (value instanceof Value) {
            Value e = (Value)value;
            value = e.value();
        }
        this.parameters.put(name, value);
    }

    public static PathElement[] deepestCommonPath(List<PathElement[]> cachedAssociation, List<PathElement> associations) {
        ArrayList common = new ArrayList();
        if (associations != null) {
            for (PathElement[] path : cachedAssociation) {
                ArrayList<PathElement> temp = new ArrayList<PathElement>();
                for (int depth = 0; depth < path.length; ++depth) {
                    PathElement pe2;
                    PathElement pe = path[depth];
                    if (depth >= associations.size() || (pe2 = associations.get(depth)).isInner() != null && !pe2.isInner().equals(pe.isInner()) || pe2.getBase() == null || !pe2.getBase().equals(pe.getBase())) break;
                    temp.add(pe);
                }
                if (temp.size() <= common.size()) continue;
                common = temp;
            }
        }
        return common.toArray(new PathElement[common.size()]);
    }

    public String getAliasForAssociation(Association association) {
        if (this.joinBag != null) {
            return this.joinBag.getAlias(association);
        }
        return null;
    }

    protected void joinTo(List<PathElement> paths, boolean fetch) {
        if (paths != null) {
            this.addJoin(paths, null, fetch);
            PathCondition[] cache = this.buildPathConditions(paths);
            List<Condition> firstConditions = null;
            for (int index = 0; index < cache.length; ++index) {
                PathCondition pathCondition = cache[index];
                if (pathCondition == null) continue;
                List<Condition> conds = pathCondition.getConditions();
                if (conds != null) {
                    if (index == 0) {
                        firstConditions = conds;
                    } else {
                        if (firstConditions != null) {
                            conds = new ArrayList<Condition>(conds);
                            conds.addAll(firstConditions);
                            firstConditions = null;
                        }
                        this.applyOn(paths.subList(0, index), Definition.and(conds));
                    }
                }
                if (pathCondition.getColumns() == null) continue;
                this.applyInclude(paths.subList(0, index), pathCondition.getColumns());
            }
        }
    }

    private PathCondition[] buildPathConditions(List<PathElement> paths) {
        int index = 0;
        List<Condition> tableConditions = null;
        PathCondition[] cache = new PathCondition[paths.size() + 1];
        for (PathElement pe : paths) {
            ++index;
            PathCondition pc = null;
            if (pe.getCondition() != null) {
                pc = new PathCondition();
                pc.addCondition(pe.getCondition());
                cache[index] = pc;
            }
            if ((tableConditions = pe.getBase().getTableTo().getConditions()) != null) {
                if (pc == null) {
                    cache[index] = pc = new PathCondition();
                }
                cache[index].addConditions(tableConditions);
            }
            if (pe.getColumns() == null) continue;
            if (pc == null) {
                cache[index] = pc = new PathCondition();
            }
            pc.setColumns(pe.getColumns());
        }
        String fkAlias = this.getTableAlias();
        index = 0;
        for (PathElement pe : paths) {
            ++index;
            List<Discriminator> discriminators = pe.getBase().getDiscriminators();
            if (discriminators != null) {
                PathCondition pc = cache[index];
                if (pc == null) {
                    cache[index] = pc = new PathCondition();
                }
                if (pe.getBase().getDiscriminatorTable().equals(pe.getBase().getTableTo())) {
                    for (Discriminator v : discriminators) {
                        pc.addCondition(v.getCondition());
                    }
                } else {
                    for (Discriminator v : discriminators) {
                        Condition crit = v.getCondition();
                        crit.setTableAlias(fkAlias);
                        pc.addCondition(crit);
                    }
                }
            }
            fkAlias = this.joinBag.getAlias(pe.getDerived());
        }
        return cache;
    }

    protected List<PathElement> addJoin(List<PathElement> associations, PathElement[] common, boolean fetch) {
        ArrayList<PathElement> local = new ArrayList<PathElement>();
        if (common == null) {
            common = DmlBase.deepestCommonPath(this.cachedAssociation, associations);
        }
        if (this.joins == null) {
            this.joins = new ArrayList<Join>();
        }
        Association[] fks = new Association[associations.size()];
        Association lastFk = null;
        boolean matches = true;
        int f = 0;
        for (PathElement pe : associations) {
            Association association = pe.getBase();
            Association lastCachedFk = null;
            if (matches && f < common.length) {
                if (common[f].getBase().equals(association)) {
                    lastCachedFk = common[f].getDerived();
                } else {
                    matches = false;
                }
            } else {
                matches = false;
            }
            if (lastCachedFk == null) {
                fks[f] = association.bareCopy();
                String fkAlias = f == 0 ? this.tableAlias : this.joinBag.getAlias(lastFk);
                if (fks[f].isMany2Many()) {
                    Association fromFk = fks[f].getFromM2M();
                    Association toFk = fks[f].getToM2M();
                    this.prepareAssociation(fkAlias, this.joinBag.getAlias(fromFk), fromFk);
                    if (pe.getPreferredAlias() == null) {
                        fkAlias = this.joinBag.getAlias(toFk);
                    } else {
                        fkAlias = pe.getPreferredAlias();
                        this.joinBag.setAlias(toFk, pe.getPreferredAlias());
                    }
                    this.prepareAssociation(this.joinBag.getAlias(fromFk), fkAlias, toFk);
                    lastFk = toFk;
                } else {
                    String fkAlias2;
                    if (pe.getPreferredAlias() == null) {
                        fkAlias2 = this.joinBag.getAlias(fks[f]);
                    } else {
                        fkAlias2 = pe.getPreferredAlias();
                        this.joinBag.setAlias(fks[f], pe.getPreferredAlias());
                    }
                    this.prepareAssociation(fkAlias, fkAlias2, fks[f]);
                    lastFk = fks[f];
                }
            } else {
                fks[f] = lastCachedFk;
                lastFk = fks[f].isMany2Many() ? fks[f].getToM2M() : lastCachedFk;
            }
            pe.setDerived(fks[f]);
            local.add(pe);
            ++f;
        }
        if (!matches) {
            this.cachedAssociation.add(local.toArray(new PathElement[0]));
        }
        this.lastFkAlias = this.joinBag.getAlias(lastFk);
        this.lastJoin = new Join(local, fetch);
        this.joins.add(this.lastJoin);
        return local;
    }

    private void prepareAssociation(String aliasFrom, String aliasTo, Association currentFk) {
        currentFk.setAliasFrom(aliasFrom);
        currentFk.setAliasTo(aliasTo);
        for (Relation rel : currentFk.getRelations()) {
            rel.getFrom().setTableAlias(aliasFrom);
            rel.getTo().setTableAlias(aliasTo);
        }
    }

    protected DmlBase where(Condition restriction) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        conditions.add(restriction);
        this.where(conditions);
        return this;
    }

    protected DmlBase where(Condition ... restrictions) {
        if (restrictions != null) {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            for (Condition restriction : restrictions) {
                conditions.add(restriction);
            }
            this.where(conditions);
        }
        return this;
    }

    protected DmlBase where(List<Condition> restrictions) {
        if (restrictions != null) {
            this.applyWhere(Definition.and(restrictions));
        }
        return this;
    }

    protected void applyOn(List<PathElement> chain, Condition condition) {
        if (chain != null && chain.size() > 0) {
            PathElement pe = chain.get(chain.size() - 1);
            Condition copy = (Condition)condition.clone();
            Association fk = pe.getDerived();
            String fkAlias = fk.isMany2Many() ? this.joinBag.getAlias(fk.getToM2M()) : this.joinBag.getAlias(pe.getDerived());
            copy.setTableAlias(fkAlias);
            this.replaceRaw(copy);
            pe.setCondition(copy);
            this.rawSql = null;
        }
    }

    protected void applyInclude(List<PathElement> chain, List<Function> tokens) {
        int len = Misc.length(chain);
        if (len > 0) {
            PathElement pe = chain.get(len - 1);
            Association fk = pe.getDerived();
            String fkAlias = this.joinBag.getAlias(fk.isMany2Many() ? fk.getToM2M() : pe.getDerived());
            for (Function token : tokens) {
                token.setTableAlias(fkAlias);
            }
            this.rawSql = null;
        }
    }

    protected void applyWhere(Condition restriction) {
        Condition cond;
        this.rawSql = null;
        this.condition = null;
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (this.discriminatorConditions != null) {
            conditions.addAll(this.discriminatorConditions);
        }
        if (restriction != null) {
            cond = (Condition)restriction.clone();
            this.replaceRaw(cond);
            cond.setTableAlias(this.tableAlias);
            conditions.add(cond);
        }
        if (!conditions.isEmpty()) {
            cond = Definition.and(conditions);
            cond.setTableAlias(this.tableAlias);
            this.condition = cond;
        }
    }

    protected String dumpParameters(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().endsWith("$")) {
                sb.append(String.format("[%s=****]", entry.getKey()));
                continue;
            }
            sb.append(String.format("[%s=%s]", entry.getKey(), entry.getValue()));
        }
        return sb.toString();
    }

    protected Driver driver() {
        return this.db.getDriver();
    }

    public SimpleJdbc getSimpleJdbc() {
        return this.simpleJdbc;
    }

    public abstract RawSql getSql();

    protected Connection connection() {
        return this.db.getConnection();
    }

    protected void debug(Logger logger, String fqcn, String format, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.log(fqcn, (Priority)Level.DEBUG, (Object)String.format(format, args), null);
        }
    }

    protected void debugTime(Logger logger, String fqcn, long now) {
        if (logger.isDebugEnabled()) {
            logger.log(fqcn, (Priority)Level.DEBUG, (Object)("executed in: " + (double)(System.nanoTime() - now) / 1000000.0 + "ms"), null);
        }
    }

    protected void debugSQL(Logger logger, String fqcn, String sql) {
        if (logger.isDebugEnabled()) {
            String caller = this.callerName(Thread.currentThread().getStackTrace(), fqcn);
            logger.log(fqcn, (Priority)Level.DEBUG, (Object)String.format("%s\n\tSQL: %s\n\tparameters: %s", caller, sql, this.dumpParameters(this.parameters)), null);
        }
    }

    protected String callerName(StackTraceElement[] stack, String fqcn) {
        for (int i = stack.length - 1; i >= 0; --i) {
            if (!stack[i].getClassName().equals(fqcn)) continue;
            StackTraceElement ste = stack[i + 1];
            return ste.getClassName() + "." + ste.getMethodName() + ":" + ste.getLineNumber();
        }
        return "[Unable to determine caller]";
    }

    protected void replaceRaw(Function token) {
        block3: {
            Function[] members;
            block4: {
                block2: {
                    members = token.getMembers();
                    if (!"RAW".equals(token.getOperator())) break block2;
                    ++this.rawIndex;
                    String parameter = this.tableAlias + "_R" + this.rawIndex;
                    this.setParameter(parameter, token.getValue());
                    token.setOperator("PARAM");
                    token.setValue(parameter);
                    break block3;
                }
                if (!"SUBQUERY".equals(token.getOperator())) break block4;
                Query subquery = (Query)token.getValue();
                Map<String, Object> pars = subquery.getParameters();
                for (Map.Entry<String, Object> entry : pars.entrySet()) {
                    this.setParameter(entry.getKey(), entry.getValue());
                }
                break block3;
            }
            if (members == null) break block3;
            for (int i = 0; i < members.length; ++i) {
                if (members[i] == null) continue;
                this.replaceRaw(members[i]);
            }
        }
    }

    protected static class PathCondition {
        private List<Function> columns;
        private List<Condition> conditions;

        protected PathCondition() {
        }

        public List<Function> getColumns() {
            return this.columns;
        }

        public void setColumns(List<Function> columns) {
            this.columns = columns;
        }

        public List<Condition> getConditions() {
            return this.conditions;
        }

        public void setConditions(List<Condition> conditions) {
            this.conditions = conditions;
        }

        public void addCondition(Condition condition) {
            if (this.conditions == null) {
                this.conditions = new ArrayList<Condition>();
            }
            this.conditions.add(condition);
        }

        public void addConditions(List<Condition> conditions) {
            if (this.conditions == null) {
                this.conditions = new ArrayList<Condition>();
            }
            this.conditions.addAll(conditions);
        }
    }
}

