/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.DmlBase;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DmlCore<T>
extends DmlBase {
    protected static final String OPTIMISTIC_LOCK_MSG = "No update was possible for this version of the data. Data may have changed.";
    protected static final String VERSION_SET_MSG = "Unable to set Version data.";
    protected static final String ID_UNDEFINED_MSG = "Field ID is undefined!";
    protected Class<?> lastBeanClass = null;
    protected Map<Column<?>, Function> values;
    protected Column<?>[] sets = null;
    private int batchLimit = 1000;

    public DmlCore(AbstractDb db, Table table) {
        super(db, table);
    }

    protected T _set(Column<?> col, Object value) {
        if (value == null) {
            value = col.getType();
        } else if (col.getType() == NullSql.CLOB && value instanceof String) {
            value = ((String)value).toCharArray();
        }
        Function token = Function.converteOne(value);
        this.replaceRaw(token);
        token.setTableAlias(this.tableAlias);
        if (this.defineParameter(col, token)) {
            this.rawSql = null;
        }
        return (T)this;
    }

    public T setNull(Column<?> col) {
        return this._set(col, null);
    }

    public T setTrue(Column<Boolean> col) {
        return this._set(col, Boolean.TRUE);
    }

    public T setFalse(Column<Boolean> col) {
        return this._set(col, Boolean.FALSE);
    }

    public T sets(Column<?> ... columns) {
        for (Column<?> col : columns) {
            if (!this.table.equals(col.getTable())) {
                throw new PersistenceException("Column " + col + " does not belong to table " + this.table);
            }
            this._set(col, null);
        }
        this.sets = columns;
        this.rawSql = null;
        return (T)this;
    }

    public T values(Object ... values) {
        if (this.sets == null) {
            throw new PersistenceException("Columns are not defined!");
        }
        if (this.sets.length != values.length) {
            throw new PersistenceException("The number of defined columns is diferent from the number of passed values!");
        }
        if (this.sets != null) {
            int i = 0;
            for (Column<?> col : this.sets) {
                this._set(col, values[i++]);
            }
        }
        return (T)this;
    }

    protected boolean defineParameter(Column<?> col, Function value) {
        Function tok;
        if (!col.getTable().getName().equals(this.table.getName())) {
            throw new PersistenceException(col + " does not belong to table " + this.table);
        }
        if (this.values == null) {
            this.values = new LinkedHashMap();
        }
        if ((tok = this.values.put(col, value)) != null) {
            if (value.getOperator() == "PARAM" && tok.getOperator() == "PARAM") {
                String oldKey = (String)tok.getValue();
                String key = (String)value.getValue();
                value.setValue(tok.getValue());
                this.parameters.put(oldKey, this.parameters.get(key));
                this.parameters.remove(key);
                return false;
            }
            if (tok.getOperator() == "PARAM") {
                this.parameters.remove((String)tok.getValue());
            }
        }
        return true;
    }

    public Map<Column<?>, Function> getValues() {
        return this.values;
    }

    protected int execute(Logger logger, String FQCN, Map<String, Object> parameters) {
        this.simpleJdbc.closeBatch();
        this.getSql();
        this.debugSQL(logger, FQCN, this.rawSql.getOriginalSql());
        Map<String, Object> pars = this.db.transformParameters(parameters);
        long now = System.nanoTime();
        int i = this.getSimpleJdbc().update(this.rawSql.getSql(), this.rawSql.buildValues(pars));
        this.debug(logger, FQCN, "result = %s", i);
        this.debugTime(logger, FQCN, now);
        this.sets = null;
        return i;
    }

    protected int[] batch(Logger logger, String FQCN, Map<String, Object> parameters) {
        this.getSql();
        Map<String, Object> pars = this.db.transformParameters(parameters);
        this.simpleJdbc.batch(this.rawSql.getSql(), this.rawSql.buildValues(pars));
        if (this.simpleJdbc.getPending() >= this.batchLimit) {
            return this.flushBatch(logger, FQCN);
        }
        return null;
    }

    protected int[] flushBatch(Logger logger, String FQCN) {
        int[] result = null;
        if (this.simpleJdbc.getPending() > 0) {
            this.debugSQL(logger, FQCN, this.rawSql.getOriginalSql());
            long now = System.nanoTime();
            result = this.simpleJdbc.flushUpdate();
            this.debugTime(logger, FQCN, now);
        }
        return result;
    }

    protected void endBatch(Logger logger, String FQCN) {
        this.flushBatch(logger, FQCN);
        this.simpleJdbc.closeBatch();
    }

    public int getPending() {
        return this.simpleJdbc.getPending();
    }

    public int getBatchLimit() {
        return this.batchLimit;
    }

    public void batchLimit(int batchLimit) {
        this.batchLimit = batchLimit;
    }
}

