/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.common.api.PostInserter;
import com.github.quintans.ezSQL.common.api.PreInserter;
import com.github.quintans.ezSQL.common.api.Updatable;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Discriminator;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.PreInsertTrigger;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.AutoKeyStrategy;
import com.github.quintans.ezSQL.dml.DmlCore;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.jdbc.RawSql;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.beans.PropertyDescriptor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Insert
extends DmlCore<Insert> {
    private static final Logger LOG = Logger.getLogger(Insert.class);
    private static final String FQCN = Insert.class.getName();
    private boolean returnKey = true;
    private boolean previousHasAllKeyValues;
    private boolean hasKeyValue;

    public Insert(AbstractDb db, Table table) {
        super(db, table);
        this.values = new LinkedHashMap();
        List<Discriminator> discriminators = table.getDiscriminators();
        if (discriminators != null) {
            for (Discriminator discriminator : discriminators) {
                this._set((Column)discriminator.getColumn(), (Object)discriminator.getValue());
            }
        }
    }

    public Insert retrieveKeys(boolean returnKey) {
        this.returnKey = returnKey;
        return this;
    }

    public Insert set(Column<?> col, Function value) {
        return this._set((Column)col, (Object)value);
    }

    public <C> Insert set(Column<C> col, C value) {
        return this._set((Column)col, (Object)value);
    }

    public <C> Insert with(Column<C> c, C value) {
        this.setParameter(c, value);
        return this;
    }

    public Insert with(String name, Object value) {
        this.setParameter(name, value);
        return this;
    }

    @Override
    protected Insert _set(Column<?> col, Object value) {
        super._set(col, value);
        if (this.table.getSingleKeyColumn() != null && col.isKey()) {
            this.hasKeyValue = value != null;
        }
        return this;
    }

    private boolean hasAllKeyValues() {
        if (this.table.getSingleKeyColumn() != null) {
            return this.hasKeyValue;
        }
        for (Column<?> col : this.table.getKeyColumns()) {
            Function val = (Function)this.values.get(col);
            if (val != null && !(val.getValue() instanceof NullSql)) continue;
            return false;
        }
        return true;
    }

    public Insert set(Object bean) {
        this.mapBean(bean, false);
        if (bean instanceof Updatable) {
            ((Updatable)bean).clear();
        }
        return this;
    }

    @Override
    public RawSql getSql() {
        if (this.rawSql == null) {
            String sql = this.driver().getSql(this);
            this.rawSql = this.getSimpleJdbc().toRawSql(sql);
        }
        return this.rawSql;
    }

    public Map<Column<?>, Object> execute() {
        boolean hasAllKeyValues;
        PreInsertTrigger pre = this.getTable().getPreInsertTrigger();
        if (pre != null) {
            pre.trigger(this);
        }
        if (this.previousHasAllKeyValues != (hasAllKeyValues = this.hasAllKeyValues())) {
            this.rawSql = null;
        }
        this.previousHasAllKeyValues = hasAllKeyValues;
        Driver driver = this.db.getDriver();
        AutoKeyStrategy strategy = driver.getAutoKeyStrategy();
        Column<?> singleKeyColumn = this.table.getSingleKeyColumn();
        RawSql cachedSql = null;
        LinkedHashMap kmap = null;
        if (this.returnKey && !hasAllKeyValues) {
            kmap = new LinkedHashMap();
        }
        switch (strategy) {
            case BEFORE: {
                if (kmap != null && singleKeyColumn != null) {
                    Long lastKey = this.getDb().fetchAutoNumberBefore(singleKeyColumn);
                    this._set((Column)singleKeyColumn, (Object)lastKey);
                    kmap.put(singleKeyColumn, lastKey);
                }
                cachedSql = this.getSql();
                this.debugSQL(LOG, FQCN, cachedSql.getOriginalSql());
                Map<String, Object> params = this.db.transformParameters(this.parameters);
                long now = System.nanoTime();
                this.getSimpleJdbc().update(cachedSql.getSql(), cachedSql.buildValues(params));
                this.debugTime(LOG, FQCN, now);
                break;
            }
            case RETURNING: {
                Column[] columns = null;
                String[] keyColumns = null;
                Set<Column<?>> kcs = null;
                if (kmap != null) {
                    kcs = this.getTable().getKeyColumns();
                    columns = new Column[kcs.size()];
                    keyColumns = new String[kcs.size()];
                    int i = 0;
                    Iterator<Column<?>> iterator = kcs.iterator();
                    while (iterator.hasNext()) {
                        Column<?> c;
                        columns[i] = c = iterator.next();
                        keyColumns[i++] = driver.columnName(c);
                    }
                }
                cachedSql = this.getSql();
                this.debugSQL(LOG, FQCN, cachedSql.getOriginalSql());
                Map<String, Object> params = this.db.transformParameters(this.parameters);
                long now = System.nanoTime();
                Object[] keys = this.getSimpleJdbc().insert(cachedSql.getSql(), keyColumns, cachedSql.buildValues(params));
                this.debugTime(LOG, FQCN, now);
                if (kmap == null) break;
                for (int i = 0; i < columns.length; ++i) {
                    kmap.put(columns[i], keys[i]);
                }
                break;
            }
            case AFTER: {
                cachedSql = this.getSql();
                this.debugSQL(LOG, FQCN, cachedSql.getOriginalSql());
                Map<String, Object> params = this.db.transformParameters(this.parameters);
                long now = System.nanoTime();
                this.getSimpleJdbc().update(cachedSql.getSql(), cachedSql.buildValues(params));
                this.debugTime(LOG, FQCN, now);
                if (kmap == null || singleKeyColumn == null) break;
                Long lastKey = this.getDb().fetchAutoNumberBefore(singleKeyColumn);
                kmap.put(singleKeyColumn, lastKey);
                break;
            }
            case NONE: {
                break;
            }
        }
        return kmap;
    }

    public int[] batch() {
        PreInsertTrigger pre = this.getTable().getPreInsertTrigger();
        if (pre != null) {
            pre.trigger(this);
        }
        return this.batch(LOG, FQCN, this.parameters);
    }

    public int[] flushBatch() {
        return this.flushBatch(LOG, FQCN);
    }

    public void endBatch() {
        this.endBatch(LOG, FQCN);
    }

    public Map<Column<?>, Object> submit(Object bean) {
        Map<Column<?>, Object> keys;
        if (bean == null) {
            return null;
        }
        if (bean instanceof PreInserter) {
            ((PreInserter)bean).preInsert();
        }
        this.mapBean(bean, true);
        if (this.table.getDiscriminators() != null) {
            for (Discriminator disc : this.table.getDiscriminators()) {
                this._set((Column)disc.getColumn(), (Object)disc.getValue());
            }
        }
        if ((keys = this.execute()) != null) {
            for (Map.Entry<Column<?>, Object> entry : keys.entrySet()) {
                Column<?> col = entry.getKey();
                Object val = entry.getValue();
                PropertyDescriptor pd = Misc.getPropertyDescriptor(bean.getClass(), col.getAlias());
                if (pd == null) continue;
                try {
                    Class<?> clazz = pd.getPropertyType();
                    if (val instanceof Number) {
                        val = Long.class.isAssignableFrom(clazz) ? (Number)((Number)val).longValue() : (Number)((Number)val).intValue();
                    }
                    pd.getWriteMethod().invoke(bean, val);
                }
                catch (Exception e) {
                    throw new PersistenceException("Unable to write to " + bean.getClass().getSimpleName() + "." + pd.getWriteMethod().getName(), (Throwable)e);
                }
            }
        }
        if (bean instanceof PostInserter) {
            ((PostInserter)bean).postInsert();
        }
        if (bean instanceof Updatable) {
            ((Updatable)bean).clear();
        }
        return keys;
    }

    private void mapBean(Object bean, boolean versioned) {
        this.parameters = new LinkedHashMap();
        this.values = new LinkedHashMap();
        if (bean.getClass() != this.lastBeanClass) {
            this.lastBeanClass = bean.getClass();
            this.rawSql = null;
        }
        Set changed = null;
        if (bean instanceof Updatable) {
            changed = ((Updatable)bean).changed();
        }
        boolean ignoreNullKeys = this.db.getDriver().ignoreNullKeys();
        for (Column<?> column : this.table.getColumns()) {
            Object o;
            String alias = column.getAlias();
            PropertyDescriptor pd = null;
            if (changed == null || column.isKey() || column.isVersion() || changed.contains(alias)) {
                pd = Misc.getPropertyDescriptor(bean.getClass(), alias);
            }
            if (pd == null) continue;
            try {
                o = pd.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (Exception e) {
                throw new PersistenceException("Unable to read from " + bean.getClass().getSimpleName() + "." + pd.getReadMethod().getName(), (Throwable)e);
            }
            if (column.isKey()) {
                if (ignoreNullKeys) {
                    // empty if block
                }
            } else if (versioned && column.isVersion() && o == null) {
                try {
                    o = Long.class.isAssignableFrom(pd.getPropertyType()) ? (Number)1L : (Number)1;
                    pd.getWriteMethod().invoke(bean, o);
                }
                catch (Exception e) {
                    throw new PersistenceException("Unable to write to " + bean.getClass().getSimpleName() + "." + pd.getWriteMethod().getName(), (Throwable)e);
                }
            }
            this._set((Column)column, o);
        }
    }
}

