/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.dml;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.db.Association;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.AliasBag;
import com.github.quintans.ezSQL.dml.ColumnHolder;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.DmlBase;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Group;
import com.github.quintans.ezSQL.dml.Join;
import com.github.quintans.ezSQL.dml.Order;
import com.github.quintans.ezSQL.dml.PathElement;
import com.github.quintans.ezSQL.dml.Union;
import com.github.quintans.ezSQL.toolkit.utils.Misc;
import com.github.quintans.ezSQL.transformers.AbstractDbRowTransformer;
import com.github.quintans.ezSQL.transformers.IProcessor;
import com.github.quintans.ezSQL.transformers.IQueryRowTransformer;
import com.github.quintans.ezSQL.transformers.MapBeanTransformer;
import com.github.quintans.ezSQL.transformers.MapTransformer;
import com.github.quintans.ezSQL.transformers.SimpleAbstractDbRowTransformer;
import com.github.quintans.jdbc.RawSql;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import com.github.quintans.jdbc.transformers.IRowTransformer;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import com.github.quintans.jdbc.transformers.SimpleAbstractRowTransformer;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Query
extends DmlBase {
    private static final Logger LOG = Logger.getLogger(Query.class);
    private static final String FQCN = Query.class.getName();
    public static final String FIRST_RESULT = "first";
    public static final String LAST_RESULT = "last";
    private String alias;
    private Query subquery;
    private boolean distinct;
    private List<Function> columns = new ArrayList<Function>();
    private List<Order> orders;
    private List<Union> unions;
    private int[] groupBy = null;
    private int skip;
    private int limit;
    private Function lastFunction = null;
    private Order lastOrder = null;
    private Condition having;
    private boolean useTree;

    public Query(AbstractDb db, Table table) {
        super(db, table);
    }

    public Query(Query subquery) {
        super(subquery.getDb(), null);
        this.subquery = subquery;
        for (Map.Entry<String, Object> entry : subquery.getParameters().entrySet()) {
            this.setParameter(entry.getKey(), entry.getValue());
        }
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isFlat() {
        return !this.useTree;
    }

    public void alias(String alias) {
        this.alias = alias;
    }

    public void copy(Query other) {
        this.table = other.getTable();
        this.tableAlias = other.getTableAlias();
        if (other.getJoins() != null) {
            this.joins = new ArrayList<Join>(other.getJoins());
        }
        if (other.getCondition() != null) {
            this.condition = (Condition)other.getCondition().clone();
        }
        if (this.parameters != null) {
            this.parameters = new LinkedHashMap<String, Object>(other.getParameters());
        }
        if (other.getSubquery() != null) {
            Query q = other.getSubquery();
            this.subquery = new Query(this.db, q.getTable());
            this.subquery.copy(q);
        }
        this.distinct = other.isDistinct();
        if (other.getColumns() != null) {
            this.columns = new ArrayList<Function>(other.getColumns());
        }
        if (other.getOrders() != null) {
            this.orders = new ArrayList<Order>(other.getOrders());
        }
        if (other.getUnions() != null) {
            this.unions = new ArrayList<Union>(other.getUnions());
        }
        if (other.getGroupBy() != null) {
            this.groupBy = (int[])other.getGroupBy().clone();
        }
        this.skip = other.getSkip();
        this.limit = other.getLimit();
        this.rawSql = other.rawSql;
    }

    public int getSkip() {
        return this.skip;
    }

    public Query skip(int firstResult) {
        this.skip = firstResult < 0 ? 0 : firstResult;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Query limit(int maxResults) {
        this.limit = maxResults < 0 ? 0 : maxResults;
        return this;
    }

    public Query getSubquery() {
        return this.subquery;
    }

    public Query distinct() {
        this.distinct = true;
        this.rawSql = null;
        return this;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public Query all() {
        if (this.table != null) {
            for (Column<?> column : this.table.getColumns()) {
                this.column(column);
            }
        }
        return this;
    }

    public Query column(Object ... cols) {
        if (cols != null && cols.length > 0) {
            for (Object col : cols) {
                this.lastFunction = Function.converteOne(col);
                this.replaceRaw(this.lastFunction);
                this.lastFunction.setTableAlias(this.tableAlias);
                this.columns.add(this.lastFunction);
            }
        }
        this.rawSql = null;
        return this;
    }

    public Query count() {
        this.column(Definition.count());
        return this;
    }

    public Query count(Object ... expr) {
        if (expr != null && expr.length > 0) {
            for (Object e : expr) {
                this.column(Definition.count(e));
            }
        }
        return this;
    }

    public Query as(String alias) {
        if (this.lastFunction != null) {
            this.lastFunction.as(alias);
        } else if (this.path != null) {
            ((PathElement)this.path.get(this.path.size() - 1)).setPreferredAlias(alias);
        } else {
            this.joinBag = new AliasBag(alias + "_" + "j");
            this.tableAlias = alias;
        }
        this.rawSql = null;
        return this;
    }

    public List<Function> getColumns() {
        return this.columns;
    }

    @Override
    public Query where(Condition restriction) {
        return (Query)super.where(restriction);
    }

    @Override
    public Query where(Condition ... restrictions) {
        return (Query)super.where(restrictions);
    }

    @Override
    public Query where(List<Condition> restrictions) {
        return (Query)super.where(restrictions);
    }

    private Query order(ColumnHolder columnHolder) {
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.lastOrder = new Order(columnHolder, true);
        this.orders.add(this.lastOrder);
        this.rawSql = null;
        return this;
    }

    public Query order(Column<?> column) {
        return this.order(column, this.tableAlias);
    }

    public Query asc(Column<?> column) {
        return this.order(column, this.tableAlias).asc();
    }

    public Query desc(Column<?> column) {
        return this.order(column, this.tableAlias).desc();
    }

    public Query order(Column<?> column, String alias) {
        ColumnHolder ch = new ColumnHolder(column);
        if (alias != null) {
            ch.setTableAlias(alias);
        } else {
            ch.setTableAlias(this.tableAlias);
        }
        return this.order(ch);
    }

    public Query asc(Column<?> column, String alias) {
        return this.order(column, this.tableAlias).asc();
    }

    public Query desc(Column<?> column, String alias) {
        return this.order(column, alias).desc();
    }

    public Query order(Column<?> column, Association ... associations) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>();
        for (Association association : associations) {
            pathElements.add(new PathElement(association, null));
        }
        return this.order(column, pathElements);
    }

    private Query order(Column<?> column, List<PathElement> pathElements) {
        PathElement[] common = Query.deepestCommonPath(this.cachedAssociation, pathElements);
        if (common.length == pathElements.size()) {
            return this.order(column, Query.pathElementAlias(common[common.length - 1]));
        }
        throw new PersistenceException("The path specified in the order is not valid");
    }

    public Query orderBy(Column<?> column) {
        if (this.path != null) {
            PathElement last = (PathElement)this.path.get(this.path.size() - 1);
            if (last.getOrders() == null) {
                last.setOrders(new ArrayList<Order>());
            }
            this.lastOrder = new Order(new ColumnHolder(column));
            last.getOrders().add(this.lastOrder);
            return this;
        }
        if (this.lastJoin != null) {
            return this.order(column, this.lastJoin.getPathElements());
        }
        return this.order(column, this.lastFkAlias);
    }

    public Query ascBy(Column<?> column) {
        return this.orderBy(column).asc();
    }

    public Query descBy(Column<?> column) {
        return this.orderBy(column).desc();
    }

    public Query order(String column) {
        if (this.orders == null) {
            this.orders = new ArrayList<Order>();
        }
        this.lastOrder = new Order(column, true);
        this.orders.add(this.lastOrder);
        this.rawSql = null;
        return this;
    }

    public Query asc(String column) {
        return this.order(column).asc();
    }

    public Query desc(String column) {
        return this.order(column).desc();
    }

    public Query asc() {
        this.asc(true);
        return this;
    }

    public Query asc(boolean dir) {
        if (this.lastOrder != null) {
            this.lastOrder.setAsc(dir);
            this.rawSql = null;
        }
        return this;
    }

    public Query desc() {
        if (this.lastOrder != null) {
            this.lastOrder.setAsc(false);
            this.rawSql = null;
        }
        return this;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    private Query _associate(boolean inner, Association ... associations) {
        if (Misc.length(associations) == 0) {
            throw new PersistenceException("Inner cannot be used with an empty association list!");
        }
        if (this.path == null) {
            this.path = new ArrayList();
        }
        Table lastTable = null;
        lastTable = this.path.size() > 0 ? ((PathElement)this.path.get(this.path.size() - 1)).getBase().getTableTo() : this.table;
        for (Association assoc : associations) {
            if (!lastTable.equals(assoc.getTableFrom())) {
                StringBuilder sb = new StringBuilder();
                sb.append("Association list ");
                for (Association a : associations) {
                    sb.append("[").append(a.genericPath()).append("]");
                }
                sb.append(" is invalid. Association [").append(assoc.genericPath()).append("] must start on table ").append(lastTable.getName());
                throw new PersistenceException(sb.toString());
            }
            lastTable = assoc.getTableTo();
        }
        for (Association association : associations) {
            PathElement pe = new PathElement(association, inner);
            this.path.add(pe);
        }
        this.rawSql = null;
        return this;
    }

    public Query inner(Association ... associations) {
        return this._associate(true, associations);
    }

    public Query outer(Association ... associations) {
        return this._associate(false, associations);
    }

    private void _fetch(List<PathElement> paths) {
        this.useTree = true;
        if (paths != null) {
            for (PathElement pe : paths) {
                this.includeInPath(pe, new Object[0]);
            }
        }
        this._join(true);
    }

    public Query fetch() {
        this._fetch(this.path);
        return this;
    }

    public Query join() {
        this._join(false);
        return this;
    }

    private void _join(boolean fetch) {
        if (this.path != null) {
            ArrayList<Function> tokens = new ArrayList<Function>();
            for (PathElement pe : this.path) {
                List<Function> funs = pe.getColumns();
                if (funs == null) continue;
                for (Function fun : funs) {
                    tokens.add(fun);
                    if (fetch) continue;
                    fun.setPseudoTableAlias(this.tableAlias);
                }
            }
            this.columns.addAll(tokens);
        }
        super.joinTo(this.path, fetch);
        if (this.path != null) {
            for (PathElement pe : this.path) {
                if (pe.getOrders() == null) continue;
                for (Order o : pe.getOrders()) {
                    o.getHolder().setTableAlias(Query.pathElementAlias(pe));
                    this.getOrders().add(o);
                }
            }
        }
        this.path = null;
        this.rawSql = null;
    }

    private static String pathElementAlias(PathElement pe) {
        Association derived = pe.getDerived();
        if (derived.isMany2Many()) {
            return derived.getToM2M().getAliasTo();
        }
        return derived.getAliasTo();
    }

    public Query innerJoin(Association ... associations) {
        return this.inner(associations).join();
    }

    public Query outerJoin(Association ... associations) {
        return this.outer(associations).join();
    }

    public Query include(Object ... columns) {
        PathElement lastPath;
        int lenPath = Misc.length(this.path);
        if (lenPath > 0) {
            lastPath = (PathElement)this.path.get(lenPath - 1);
            Table lastTable = lastPath.getBase().getTableTo();
            for (Object c : columns) {
                Column col;
                if (!(c instanceof Column) || (col = (Column)c).getTable().equals(lastTable)) continue;
                throw new PersistenceException(String.format("Column %s does not belong to the table target by the association %s.", col.toString(), lastPath.getBase().genericPath()));
            }
        } else {
            throw new PersistenceException("There is no current join");
        }
        this.includeInPath(lastPath, columns);
        this.rawSql = null;
        return this;
    }

    private void includeInPath(PathElement lastPath, Object ... columns) {
        if (Misc.length(columns) > 0 || Misc.length(lastPath.getColumns()) == 0) {
            List<Function> toks;
            if (Misc.length(columns) == 0) {
                columns = lastPath.getBase().getTableTo().getColumns().toArray();
            }
            if ((toks = lastPath.getColumns()) == null) {
                toks = new ArrayList<Function>();
                lastPath.setColumns(toks);
            }
            for (Object c : columns) {
                this.lastFunction = Function.converteOne(c);
                toks.add(this.lastFunction);
            }
        }
    }

    public Query exclude(Column<?> ... columns) {
        LinkedHashSet remain;
        int lenPath = Misc.length(this.path);
        if (lenPath > 0) {
            if (Misc.length(columns) == 0) {
                throw new PersistenceException("null or empty values was passed");
            }
            Set<Column<?>> cols = ((PathElement)this.path.get(lenPath - 1)).getBase().getTableTo().getColumns();
            remain = new LinkedHashSet(cols);
            for (Column<?> c : columns) {
                remain.remove(c);
            }
        } else {
            throw new PersistenceException("There is no current join");
        }
        this.include(remain.toArray());
        return this;
    }

    public Query outerFetch(Association ... associations) {
        this.outer(associations).fetch();
        return this;
    }

    public Query innerFetch(Association ... associations) {
        this.inner(associations).fetch();
        return this;
    }

    public Query on(Condition ... condition) {
        int lenPath = Misc.length(this.path);
        if (lenPath > 0) {
            if (Misc.length(condition) == 0) {
                throw new PersistenceException("null or empty criterias was passed");
            }
        } else {
            throw new PersistenceException("There is no current join");
        }
        Condition retriction = Definition.and(condition);
        ((PathElement)this.path.get(lenPath - 1)).setCondition(retriction);
        this.rawSql = null;
        return this;
    }

    public Query union(Query query) {
        if (this.unions == null) {
            this.unions = new ArrayList<Union>();
        }
        this.unions.add(new Union(query, false));
        this.rawSql = null;
        return this;
    }

    public Query unionAll(Query query) {
        if (this.unions == null) {
            this.unions = new ArrayList<Union>();
        }
        this.unions.add(new Union(query, true));
        this.rawSql = null;
        return this;
    }

    public List<Union> getUnions() {
        return this.unions;
    }

    public Query groupByUntil(int untilPos) {
        int[] pos = new int[untilPos];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = i + 1;
        }
        this.groupBy = pos;
        this.rawSql = null;
        return this;
    }

    public Query groupBy(int ... pos) {
        this.groupBy = pos;
        this.rawSql = null;
        return this;
    }

    public int[] getGroupBy() {
        return this.groupBy;
    }

    public List<Group> getGroupByFunction() {
        int length;
        ArrayList<Group> groups = null;
        int n = length = this.groupBy == null ? 0 : this.groupBy.length;
        if (length > 0) {
            groups = new ArrayList<Group>(length);
            for (int k = 0; k < length; ++k) {
                int idx = this.groupBy[k] - 1;
                groups.add(new Group(idx, this.columns.get(idx)));
            }
        }
        return groups;
    }

    public Query groupBy(Column<?> ... cols) {
        this.rawSql = null;
        if (cols == null || cols.length == 0) {
            this.groupBy = null;
            return this;
        }
        this.groupBy = new int[cols.length];
        int pos = 1;
        for (int i = 0; i < cols.length; ++i) {
            for (Function function : this.columns) {
                ColumnHolder ch;
                if (!(function instanceof ColumnHolder) || !(ch = (ColumnHolder)function).getColumn().equals(cols[i])) continue;
                this.groupBy[i] = pos;
                break;
            }
            ++pos;
            if (this.groupBy[i] != 0) continue;
            throw new PersistenceException(String.format("Column alias '%' was not found", cols[i]));
        }
        return this;
    }

    public Query groupBy(String ... aliases) {
        this.rawSql = null;
        if (aliases == null || aliases.length == 0) {
            this.groupBy = null;
            return this;
        }
        this.groupBy = new int[aliases.length];
        int pos = 1;
        for (int i = 0; i < aliases.length; ++i) {
            for (Function function : this.columns) {
                if (!aliases[i].equals(function.getAlias())) continue;
                this.groupBy[i] = pos;
                break;
            }
            ++pos;
            if (this.groupBy[i] != 0) continue;
            throw new PersistenceException(String.format("Column alias '%' was not found", aliases[i]));
        }
        return this;
    }

    public Condition getHaving() {
        return this.having;
    }

    public Query having(Condition ... having) {
        if (having != null) {
            this.having = Definition.and(having);
            this.replaceAlias(this.having);
        }
        return this;
    }

    private void replaceAlias(Function token) {
        Function[] members = token.getMembers();
        if (token.getOperator() == "ALIAS") {
            String alias = (String)token.getValue();
            for (Function v : this.columns) {
                if (!alias.equals(v.getAlias())) continue;
                token.as(alias);
                token.setMembers(v.getMembers());
                token.setOperator(v.getOperator());
                token.setTableAlias(v.getTableAlias());
                token.setValue(v.getValue());
                break;
            }
            return;
        }
        if (members != null) {
            for (Function t : members) {
                if (t == null) continue;
                this.replaceAlias(t);
            }
        }
    }

    public void run(IProcessor processor) {
        this.list(this.createReflectionTransformer(processor));
    }

    public void runOne(IProcessor processor) {
        this.fetchUnique(this.createReflectionTransformer(processor));
    }

    public void runFirst(IProcessor processor) {
        this.select(this.createReflectionTransformer(processor));
    }

    private AbstractDbRowTransformer<Void> createReflectionTransformer(final Object processor) {
        Method[] methods = processor.getClass().getDeclaredMethods();
        if (methods.length != 1) {
            throw new PersistenceException("The supplied object must have one declared method. Found " + methods.length + " methods!");
        }
        final Method method = methods[0];
        final Class[] clazzes = method.getParameterTypes();
        if (clazzes.length == 0) {
            throw new PersistenceException("The method " + method.getName() + " must have at least one parameter!");
        }
        method.setAccessible(true);
        final int offset = this.driver().paginationColumnOffset(this);
        return new AbstractDbRowTransformer<Void>(this.getDb()){

            @Override
            public Void transform(ResultSetWrapper rsw) throws SQLException {
                Object[] objs = Query.this.transform(rsw, offset, clazzes);
                try {
                    method.invoke(processor, objs);
                }
                catch (Exception e) {
                    Object[] c = new Class[objs.length];
                    for (int i = 0; i < objs.length; ++i) {
                        Object o = objs[i];
                        c[i] = o != null ? o.getClass() : null;
                    }
                    throw new PersistenceException("There was an error while calling the method \"" + method.getName() + "\" with " + Arrays.toString(objs) + " -> " + Arrays.toString(c) + ": " + e.getMessage(), (Throwable)e);
                }
                return null;
            }
        };
    }

    public List<Object[]> listRaw(Class<?> ... clazzes) {
        return this.list(this.createRawTransformer(clazzes));
    }

    public Object[] uniqueRaw(Class<?> ... clazzes) {
        return this.fetchUnique(this.createRawTransformer(clazzes));
    }

    private SimpleAbstractDbRowTransformer<Object[]> createRawTransformer(final Class<?> ... clazzes) {
        if (Misc.length(clazzes) == 0) {
            throw new PersistenceException("Classes must be defined!");
        }
        final int offset = this.driver().paginationColumnOffset(this);
        return new SimpleAbstractDbRowTransformer<Object[]>(this.getDb()){

            @Override
            public Object[] transform(ResultSetWrapper rsw) throws SQLException {
                return Query.this.transform(rsw, offset, clazzes);
            }
        };
    }

    private Object[] transform(ResultSetWrapper rsw, int offset, Class<?> ... clazzes) throws SQLException {
        int[] columnTypes = rsw.getColumnTypes();
        int cnt = 0;
        cnt = clazzes.length > 0 ? Math.min(columnTypes.length, clazzes.length) : columnTypes.length;
        Object[] objs = new Object[cnt];
        for (int i = 0; i < cnt; ++i) {
            objs[i] = this.driver().fromDb(rsw, i + 1 + offset, cnt > 0 ? clazzes[i] : null);
        }
        return objs;
    }

    public <T> List<T> listRaw(final Class<T> clazz) {
        final int offset = this.driver().paginationColumnOffset(this);
        return this.list(new SimpleAbstractDbRowTransformer<T>(this.getDb()){

            @Override
            public T transform(ResultSetWrapper rsw) throws SQLException {
                return this.driver().fromDb(rsw, 1 + offset, clazz);
            }
        });
    }

    public <T> T uniqueRaw(final Class<T> clazz) {
        final int offset = this.driver().paginationColumnOffset(this);
        return this.fetchUnique(new SimpleAbstractDbRowTransformer<T>(this.getDb()){

            @Override
            public T transform(ResultSetWrapper rsw) throws SQLException {
                return this.driver().fromDb(rsw, 1 + offset, clazz);
            }
        });
    }

    public Boolean uniqueBoolean() {
        final int offset = this.driver().paginationColumnOffset(this);
        return this.fetchUnique(new SimpleAbstractDbRowTransformer<Boolean>(this.getDb()){

            @Override
            public Boolean transform(ResultSetWrapper rsw) throws SQLException {
                return this.driver().toBoolean(rsw, 1 + offset);
            }
        });
    }

    public Integer uniqueInteger() {
        final int offset = this.driver().paginationColumnOffset(this);
        return (Integer)this.fetchUnique((IRowTransformer)new SimpleAbstractRowTransformer<Integer>(){

            public Integer transform(ResultSetWrapper rsw) throws SQLException {
                return rsw.getResultSet().getInt(1 + offset);
            }
        });
    }

    public Long uniqueLong() {
        final int offset = this.driver().paginationColumnOffset(this);
        return (Long)this.fetchUnique((IRowTransformer)new SimpleAbstractRowTransformer<Long>(){

            public Long transform(ResultSetWrapper rsw) throws SQLException {
                return rsw.getResultSet().getLong(1 + offset);
            }
        });
    }

    public Float uniqueFloat() {
        final int offset = this.driver().paginationColumnOffset(this);
        return (Float)this.fetchUnique((IRowTransformer)new SimpleAbstractRowTransformer<Float>(){

            public Float transform(ResultSetWrapper rsw) throws SQLException {
                return Float.valueOf(rsw.getResultSet().getFloat(1 + offset));
            }
        });
    }

    public Double uniqueDouble() {
        final int offset = this.driver().paginationColumnOffset(this);
        return (Double)this.fetchUnique((IRowTransformer)new SimpleAbstractRowTransformer<Double>(){

            public Double transform(ResultSetWrapper rsw) throws SQLException {
                return rsw.getResultSet().getDouble(1 + offset);
            }
        });
    }

    public String uniqueString() {
        final int offset = this.driver().paginationColumnOffset(this);
        return (String)this.fetchUnique((IRowTransformer)new SimpleAbstractRowTransformer<String>(){

            public String transform(ResultSetWrapper rsw) throws SQLException {
                return rsw.getResultSet().getString(1 + offset);
            }
        });
    }

    public BigDecimal uniqueBigDecimal() {
        final int offset = this.driver().paginationColumnOffset(this);
        return (BigDecimal)this.fetchUnique((IRowTransformer)new SimpleAbstractRowTransformer<BigDecimal>(){

            public BigDecimal transform(ResultSetWrapper rsw) throws SQLException {
                return rsw.getResultSet().getBigDecimal(1 + offset);
            }
        });
    }

    private <T> T fetchUnique(IRowTransformer<T> rt) {
        RawSql rsql = this.getSql();
        this.debugSQL(LOG, FQCN, rsql.getOriginalSql());
        long now = System.nanoTime();
        Map<String, Object> params = this.db.transformParameters(this.parameters);
        Object o = this.getSimpleJdbc().queryUnique(rsql.getSql(), rt, rsql.buildValues(params));
        this.debugTime(LOG, FQCN, now);
        return (T)o;
    }

    public <T> List<T> list(Class<T> klass, boolean reuse) {
        return this.list(new MapTransformer(this, reuse, new MapBeanTransformer<T>(klass, this.getDb().getDriver())));
    }

    public <T> List<T> list(Class<T> klass) {
        return this.list(klass, true);
    }

    public <T> List<T> list(IQueryRowTransformer<T> transformer) {
        transformer.setQuery(this);
        return this.list((IRowTransformer<T>)transformer);
    }

    public <T> List<T> list(IRowTransformer<T> rowMapper) {
        if (this.path != null) {
            this.join();
        }
        RawSql rsql = this.getSql();
        this.debugSQL(LOG, FQCN, rsql.getOriginalSql());
        Map<String, Object> pars = this.db.transformParameters(this.parameters);
        long now = System.nanoTime();
        List list = null;
        list = this.driver().useSQLPagination() ? this.getSimpleJdbc().queryRange(rsql.getSql(), rowMapper, 0, 0, rsql.buildValues(pars)) : this.getSimpleJdbc().queryRange(rsql.getSql(), rowMapper, this.skip, this.limit, rsql.buildValues(pars));
        this.debugTime(LOG, FQCN, now);
        return list;
    }

    public <T> T unique(IRowTransformer<T> rowMapper) {
        if (this.path != null) {
            this.join();
        }
        RawSql rsql = this.getSql();
        this.debugSQL(LOG, FQCN, rsql.getOriginalSql());
        Map<String, Object> pars = this.db.transformParameters(this.parameters);
        long now = System.nanoTime();
        Object result = this.getSimpleJdbc().queryUnique(rsql.getSql(), rowMapper, rsql.buildValues(pars));
        this.debugTime(LOG, FQCN, now);
        return (T)result;
    }

    public <T> T unique(Class<T> klass) {
        if (this.useTree) {
            return this.select(klass);
        }
        return this.unique(new MapTransformer(this, false, new MapBeanTransformer<T>(klass, this.getDb().getDriver())));
    }

    public <T> T select(Class<T> klass) {
        return this.select(klass, true);
    }

    public <T> T select(Class<T> klass, boolean reuse) {
        if (this.useTree) {
            if (reuse) {
                List list = this.list(new MapTransformer(this, true, new MapBeanTransformer<T>(klass, this.getDb().getDriver())));
                if (list.size() == 0) {
                    return null;
                }
                return list.get(0);
            }
            return this.select(new MapTransformer(this, false, new MapBeanTransformer<T>(klass, this.getDb().getDriver())));
        }
        return this.select(new MapTransformer(this, false, new MapBeanTransformer<T>(klass, this.getDb().getDriver())));
    }

    public <T> T select(IRowTransformer<T> rowMapper) {
        int holdMax = this.limit;
        this.limit(1);
        List<T> list = this.list(rowMapper);
        this.limit(holdMax);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public RawSql getSql() {
        if (this.rawSql == null) {
            String sql = this.driver().getSql(this);
            this.rawSql = this.getSimpleJdbc().toRawSql(sql);
        }
        return this.rawSql;
    }

    public Function subQuery() {
        return Definition.subQuery(this);
    }
}

