/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Insert;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.InsertBuilder;
import com.github.quintans.ezSQL.toolkit.utils.Appender;
import java.util.Map;

public class GenericInsertBuilder
implements InsertBuilder {
    protected Insert insert;
    protected Appender tablePart = new Appender();
    protected Appender columnPart = new Appender(", ");
    protected Appender valuePart = new Appender(", ");

    public GenericInsertBuilder(Insert insert) {
        this.insert = insert;
        this.from();
        this.column();
    }

    protected Driver driver() {
        return this.insert.getDb().getDriver();
    }

    @Override
    public String getColumnPart() {
        return this.columnPart.toString();
    }

    @Override
    public String getValuePart() {
        return this.valuePart.toString();
    }

    @Override
    public String getTablePart() {
        return this.tablePart.toString();
    }

    public void column() {
        Map<Column<?>, Function> values = null;
        values = this.insert.getValues();
        Map<String, Object> parameters = this.insert.getParameters();
        if (values != null) {
            for (Map.Entry<Column<?>, Function> entry : values.entrySet()) {
                String val;
                Object param;
                Column<?> column = entry.getKey();
                Function token = entry.getValue();
                if (column.isKey() && this.driver().ignoreNullKeys() && "PARAM" == token.getOperator() && ((param = parameters.get(token.getValue())) == null || param instanceof NullSql)) {
                    token = null;
                }
                if (token == null || (val = this.driver().translate(EDml.INSERT, token)) == null) continue;
                this.columnPart.add(this.driver().columnName(column));
                this.valuePart.add(val);
            }
        }
    }

    public void from() {
        Table table = this.insert.getTable();
        this.tablePart.add(this.driver().tableName(table));
    }
}

