/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Update;
import com.github.quintans.ezSQL.driver.Driver;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.UpdateBuilder;
import com.github.quintans.ezSQL.toolkit.utils.Appender;
import java.util.Map;

public class GenericUpdateBuilder
implements UpdateBuilder {
    protected Update update;
    protected Appender tablePart = new Appender();
    protected Appender columnPart = new Appender(", ");
    protected Appender wherePart = new Appender(" AND ");

    public GenericUpdateBuilder(Update update) {
        this.update = update;
        this.columns();
        this.from();
        this.where();
    }

    protected Driver driver() {
        return this.update.getDb().getDriver();
    }

    @Override
    public String getColumnPart() {
        return this.columnPart.toString();
    }

    @Override
    public String getTablePart() {
        return this.tablePart.toString();
    }

    @Override
    public String getWherePart() {
        return this.wherePart.toString();
    }

    public void columns() {
        Map<Column<?>, Function> values = this.update.getValues();
        if (values != null) {
            for (Map.Entry<Column<?>, Function> entry : values.entrySet()) {
                this.column(entry.getKey(), entry.getValue());
            }
        }
    }

    public void column(Column<?> column, Function token) {
        this.columnPart.addAsOne(this.update.getTableAlias(), ".", this.driver().columnName(column), " = ", this.driver().translate(EDml.UPDATE, token));
    }

    public void from() {
        Table table = this.update.getTable();
        String alias = this.update.getTableAlias();
        this.tablePart.addAsOne(this.driver().tableName(table), " ", this.driver().tableAlias(alias));
    }

    public void where() {
        Condition criteria = this.update.getCondition();
        if (criteria != null) {
            this.wherePart.add(this.driver().translate(EDml.UPDATE, criteria));
        }
    }
}

