/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.dml.AutoKeyStrategy;
import com.github.quintans.ezSQL.dml.ColumnHolder;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.GenericDriver;
import com.github.quintans.jdbc.exceptions.PersistenceException;

public class H2Driver
extends GenericDriver {
    @Override
    public String getAutoNumberQuery(Column<? extends Number> column, boolean current) {
        if (column.isKey()) {
            return "call identity()";
        }
        throw new PersistenceException(String.format("A fun\u00e7\u00e3o getAutoNumberQuery n\u00e3o reconhece a coluna %s.", column));
    }

    @Override
    public boolean useSQLPagination() {
        return true;
    }

    @Override
    public String secondsdiff(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("DATEDIFF('SS', %s)", this.rolloverParameter(dmlType, o, ", "));
    }

    @Override
    public String paginate(Query query, String sql) {
        StringBuilder sb = new StringBuilder();
        if (query.getLimit() > 0) {
            sb.append(" LIMIT :").append("last");
            query.setParameter("last", (Object)query.getLimit());
            if (query.getSkip() > 0) {
                sb.append(" OFFSET :").append("first");
                query.setParameter("first", (Object)query.getSkip());
            }
        }
        return String.format("%s%s", sql, sb.toString());
    }

    @Override
    public String columnAlias(Function function, int position) {
        String alias = function.getAlias();
        if (alias == null) {
            if (function instanceof ColumnHolder) {
                ColumnHolder ch = (ColumnHolder)function;
                alias = ch.getTableAlias() + "_" + ch.getColumn().getName();
            } else if (!"ALIAS".equals(function.getOperator())) {
                alias = "COL_" + position;
            }
        }
        return alias;
    }

    @Override
    public AutoKeyStrategy getAutoKeyStrategy() {
        return AutoKeyStrategy.RETURNING;
    }
}

