/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.AbstractDb;
import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Sequence;
import com.github.quintans.ezSQL.dml.AutoKeyStrategy;
import com.github.quintans.ezSQL.dml.ColumnHolder;
import com.github.quintans.ezSQL.dml.Condition;
import com.github.quintans.ezSQL.dml.Definition;
import com.github.quintans.ezSQL.dml.Delete;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Join;
import com.github.quintans.ezSQL.dml.PathElement;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.dml.Update;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.GenericDriver;
import com.github.quintans.jdbc.PreparedStatementCallback;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;

public class OracleDriver
extends GenericDriver {
    private static final int NAME_MAX_LEN = 30;
    private boolean sqlPagination = true;

    @Override
    public AutoKeyStrategy getAutoKeyStrategy() {
        return AutoKeyStrategy.BEFORE;
    }

    @Override
    public String getAutoNumberQuery(Column<? extends Number> column, boolean current) {
        if (column.isKey()) {
            return "select S_" + column.getTable().getName() + (current ? ".CURRVAL" : ".NEXTVAL") + " from DUAL";
        }
        throw new PersistenceException(String.format("A fun\u00e7\u00e3o getAutoNumberQuery n\u00e3o reconhece a coluna %s.", column));
    }

    @Override
    public String getSql(Sequence sequence, boolean nextValue) {
        return String.format("select %s.%s from DUAL", sequence.getName().toUpperCase(), nextValue ? "NEXTVAL" : "CURRVAL");
    }

    @Override
    protected String getDefault() {
        return "null";
    }

    @Override
    public int paginationColumnOffset(Query query) {
        if (this.useSQLPagination() && query.getSkip() >= 1) {
            return 1;
        }
        return 0;
    }

    public void setUseSQLPagination(boolean sqlPagination) {
        this.sqlPagination = sqlPagination;
    }

    @Override
    public boolean useSQLPagination() {
        return this.sqlPagination;
    }

    @Override
    public String autoNumber(EDml dmlType, Function function) {
        Function[] o = function.getMembers();
        Column<?> column = ((ColumnHolder)o[0]).getColumn();
        if (column.isKey()) {
            return String.format("S_SGNID.NEXTVAL", new Object[0]);
        }
        if (column.isDeletion()) {
            return String.format("S_SGNSTATUSREGISTO.NEXTVAL", new Object[0]);
        }
        throw new PersistenceException(String.format("A opera\u00e7\u00e3o autonumber n\u00e3o reconhece a coluna %s.", column));
    }

    @Override
    public String secondsdiff(EDml dmlType, Function function) {
        Object[] o = function.getMembers();
        return String.format("(SYSDATE - ( %s ) - SYSDATE)*86400", this.rolloverParameter(dmlType, o, " - "));
    }

    @Override
    public String now(EDml dmlType, Function function) {
        return "SYSDATE";
    }

    @Override
    public String paginate(Query query, String sql) {
        if (query.getSkip() > 0) {
            query.setParameter("first", (Object)(query.getSkip() + 1));
            query.setParameter("last", (Object)(query.getSkip() + query.getLimit()));
            return String.format("select * from\t( select rownum rnum, a.* from ( %s ) a where rownum <= :%s ) where rnum >= :%s", sql, "last", "first");
        }
        if (query.getLimit() > 0) {
            query.setParameter("last", (Object)query.getLimit());
            return String.format("select * from ( %s ) where rownum <= :%s", sql, "last");
        }
        return sql;
    }

    @Override
    public String columnAlias(Function function, int position) {
        String alias = function.getAlias();
        if (alias == null) {
            if (function instanceof ColumnHolder) {
                ColumnHolder ch = (ColumnHolder)function;
                alias = ch.getTableAlias() + "_" + ch.getColumn().getName();
                if (alias.length() > 30) {
                    alias = alias.substring(0, 27) + position;
                }
            } else if (!"ALIAS".equals(function.getOperator())) {
                alias = "COL_" + position;
            }
        }
        return alias;
    }

    @Override
    public Boolean toBoolean(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Object o = rs.getObject(columnIndex);
        return rs.wasNull() ? null : Boolean.valueOf("1".equals(o));
    }

    @Override
    public Date toTimestamp(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        Timestamp o = rs.getTimestamp(columnIndex, this.getCalendar());
        return rs.wasNull() ? null : new Date(o.getTime());
    }

    @Override
    public Object fromBoolean(Boolean o) {
        if (o != null) {
            return o != false ? "1" : "0";
        }
        return NullSql.CHAR;
    }

    @Override
    public Object fromTimestamp(final Date o) {
        if (o == null) {
            return NullSql.DATE;
        }
        return new PreparedStatementCallback(){

            public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
                ps.setTimestamp(columnIndex, new Timestamp(o.getTime()), OracleDriver.this.getCalendar());
            }
        };
    }

    @Override
    protected Object toDefault(ResultSetWrapper rsw, int columnIndex) throws SQLException {
        ResultSet rs = rsw.getResultSet();
        int sqlType = rsw.getSqlType(columnIndex);
        Object o = null;
        switch (sqlType) {
            case 92: {
                o = rs.getTime(columnIndex);
                break;
            }
            case 91: {
                o = rs.getDate(columnIndex);
                break;
            }
            case 93: {
                o = rs.getTimestamp(columnIndex, this.getCalendar());
                break;
            }
            case 1: {
                o = rs.getString(columnIndex);
                if ("0".equals(o)) {
                    o = false;
                    break;
                }
                if (!"1".equals(o)) break;
                o = true;
                break;
            }
            default: {
                o = rs.getObject(columnIndex);
            }
        }
        if (rs.wasNull()) {
            return null;
        }
        return o;
    }

    @Override
    public String getSql(Update update) {
        if (update.getJoins() != null) {
            StringBuilder set = new StringBuilder();
            StringBuilder sb = new StringBuilder();
            sb.append("update (");
            AbstractDb db = update.getDb();
            Query query = db.query(update.getTable());
            Map<Column<?>, Function> values = update.getValues();
            int idx = 1;
            for (Map.Entry<Column<?>, Function> entry : values.entrySet()) {
                String key = "key_" + idx;
                String val = "val_" + idx;
                query.column(entry.getKey()).as(key);
                query.column(entry.getValue()).as(val);
                if (idx > 1) {
                    set.append(", ");
                }
                set.append(key).append(" = ").append(val);
                ++idx;
            }
            for (Join join : update.getJoins()) {
                for (PathElement pathElement : join.getPathElements()) {
                    if (pathElement.isInner().booleanValue()) {
                        query.inner(pathElement.getBase());
                        continue;
                    }
                    query.outer(pathElement.getBase());
                }
                query.join();
            }
            if (update.getCondition() != null) {
                query.where(update.getCondition());
            }
            sb.append(this.getSql(query)).append(") set ").append(set.toString());
            return sb.toString();
        }
        return super.getSql(update);
    }

    @Override
    public String getSql(Delete delete) {
        String sql = super.getSql(delete);
        if (delete.getJoins() != null) {
            StringBuilder sb = new StringBuilder(sql);
            if (delete.getCondition() != null) {
                sb.append(" and ");
            } else {
                sb.append(" where ");
            }
            sb.append("exists (");
            String alias = delete.getTable().getAlias() + "_i";
            Query query = delete.getDb().query(delete.getTable()).as(alias).column(Definition.asIs(1L));
            for (Join join : delete.getJoins()) {
                for (PathElement pathElement : join.getPathElements()) {
                    if (pathElement.isInner().booleanValue()) {
                        query.inner(pathElement.getBase());
                        continue;
                    }
                    query.outer(pathElement.getBase());
                }
                query.join();
            }
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            for (Column<?> column : delete.getTable().getKeyColumns()) {
                conditions.add(column.is(column.of(alias)));
            }
            query.where(conditions);
            sb.append(this.getSql(query)).append(")");
            return sb.toString();
        }
        return sql;
    }
}

