/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.driver;

import com.github.quintans.ezSQL.db.Column;
import com.github.quintans.ezSQL.db.NullSql;
import com.github.quintans.ezSQL.db.Table;
import com.github.quintans.ezSQL.dml.AutoKeyStrategy;
import com.github.quintans.ezSQL.dml.Function;
import com.github.quintans.ezSQL.dml.Query;
import com.github.quintans.ezSQL.dml.Update;
import com.github.quintans.ezSQL.driver.EDml;
import com.github.quintans.ezSQL.driver.GenericDriver;
import com.github.quintans.ezSQL.driver.GenericUpdateBuilder;
import com.github.quintans.ezSQL.driver.UpdateBuilder;
import com.github.quintans.ezSQL.jdbc.AbstractNullPreparedStatementCallback;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PostgreSQLDriver
extends GenericDriver {
    private String TIME_ZONE = "UTC";
    private AbstractNullPreparedStatementCallback nullBlob = new AbstractNullPreparedStatementCallback(NullSql.BLOB){

        public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
            ps.setBytes(columnIndex, null);
        }
    };
    private AbstractNullPreparedStatementCallback nullClob = new AbstractNullPreparedStatementCallback(NullSql.CLOB){

        public void execute(PreparedStatement ps, int columnIndex) throws SQLException {
            ps.setBytes(columnIndex, null);
        }
    };

    public PostgreSQLDriver() {
        this.setTimeZoneId(this.TIME_ZONE);
    }

    @Override
    public String getAutoNumberQuery(Column<? extends Number> column, boolean current) {
        if (column.isKey()) {
            return String.format("SELECT %s('%s_%s_seq');", current ? "currval" : "nextval", this.tableName(column.getTable()), this.columnName(column));
        }
        throw new PersistenceException(String.format("column '%s' must be key.", column));
    }

    @Override
    public boolean useSQLPagination() {
        return true;
    }

    @Override
    public String paginate(Query query, String sql) {
        StringBuilder sb = new StringBuilder();
        if (query.getLimit() > 0) {
            sb.append(sql).append(" LIMIT :").append("last");
            query.setParameter("last", (Object)query.getLimit());
            if (query.getSkip() > 0) {
                sb.append(" OFFSET :").append("first");
                query.setParameter("first", (Object)query.getSkip());
            }
            return sb.toString();
        }
        return sql;
    }

    @Override
    public AutoKeyStrategy getAutoKeyStrategy() {
        return AutoKeyStrategy.RETURNING;
    }

    @Override
    public boolean ignoreNullKeys() {
        return true;
    }

    @Override
    public String tableName(Table table) {
        return table.getName().toLowerCase();
    }

    @Override
    public String columnName(Column<?> column) {
        return column.getName().toLowerCase();
    }

    @Override
    public UpdateBuilder createUpdateBuilder(Update update) {
        return new GenericUpdateBuilder(update){

            @Override
            public void column(Column<?> column, Function token) {
                this.columnPart.addAsOne(this.driver().columnName(column), " = ", this.driver().translate(EDml.UPDATE, token));
            }
        };
    }

    @Override
    public Object fromNull(NullSql type) {
        switch (type) {
            case CLOB: {
                return this.nullClob;
            }
            case BLOB: {
                return this.nullBlob;
            }
        }
        return super.fromNull(type);
    }
}

