/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.toolkit.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;

public class BinStore
implements Serializable {
    private static final long serialVersionUID = 2237570099615271025L;
    public static final int DEFAULT_THRESHOLD = 65535;
    private long size = -1L;
    private int sizeThreshold = 65535;
    private byte[] cachedContent;
    private transient DeferredFileOutputStream dfos;
    private transient File tempFile;
    private File dfosFile;

    public BinStore() {
    }

    public BinStore(byte[] data) {
        this.set(data);
    }

    public BinStore(int sizeThreshold, byte[] data) {
        this(sizeThreshold);
        this.set(data);
    }

    public BinStore(int sizeThreshold) {
        this.sizeThreshold = sizeThreshold;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.isInMemory()) {
            return new FileInputStream(this.dfos.getFile());
        }
        if (this.cachedContent == null) {
            this.cachedContent = this.dfos.getData();
        }
        return new ByteArrayInputStream(this.cachedContent);
    }

    public boolean isInMemory() {
        if (this.cachedContent != null) {
            return true;
        }
        return this.dfos.isInMemory();
    }

    public long getSize() {
        if (this.size >= 0L) {
            return this.size;
        }
        if (this.cachedContent != null) {
            return this.cachedContent.length;
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getData().length;
        }
        return this.dfos.getFile().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get() {
        if (this.isInMemory()) {
            if (this.cachedContent == null) {
                this.cachedContent = this.dfos.getData();
            }
            return this.cachedContent;
        }
        byte[] fileData = new byte[(int)this.getSize()];
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.dfos.getFile());
            fis.read(fileData);
        }
        catch (IOException e) {
            try {
                fileData = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        IOUtils.closeQuietly((InputStream)fis);
        return fileData;
    }

    public void set(byte[] data) {
        try {
            this.cachedContent = null;
            this.copyAndClose(new ByteArrayInputStream(data), this.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void set(File source) throws IOException {
        this.set(new FileInputStream(source));
    }

    public void set(InputStream source) throws IOException {
        OutputStream out = null;
        try {
            out = this.getOutputStream();
            IOUtils.copy((InputStream)source, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) throws Exception {
        if (this.isInMemory()) {
            try (FileOutputStream fout = null;){
                fout = new FileOutputStream(file);
                fout.write(this.get());
            }
        }
        File outputFile = this.getStoreLocation();
        if (outputFile != null) {
            this.size = outputFile.length();
            if (!outputFile.renameTo(file)) {
                BufferedInputStream in = null;
                FilterOutputStream out = null;
                try {
                    in = new BufferedInputStream(new FileInputStream(outputFile));
                    out = new BufferedOutputStream(new FileOutputStream(file));
                    IOUtils.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            throw new IOException("Cannot write to disk!");
        }
    }

    public void delete() {
        this.cachedContent = null;
        File outputFile = this.getStoreLocation();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return this.getOutputStream(null);
    }

    public OutputStream getOutputStream(File directory) throws IOException {
        this.dfos = new DeferredFileOutputStream(this.sizeThreshold, this.getTempFile(directory));
        return this.dfos;
    }

    public File getStoreLocation() {
        return this.dfos == null ? null : this.dfos.getFile();
    }

    protected void finalize() {
        File outputFile = this.dfos.getFile();
        if (outputFile != null && outputFile.exists()) {
            outputFile.delete();
        }
    }

    protected File getTempFile(File directory) {
        if (this.tempFile == null) {
            try {
                this.tempFile = directory != null && directory.isDirectory() ? File.createTempFile("byteCache_", null, directory) : File.createTempFile("byteCache_", null);
                this.tempFile.deleteOnExit();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.tempFile;
    }

    private void copyAndClose(InputStream in, OutputStream out) throws IOException {
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    public String toString() {
        return "StoreLocation=" + (this.isInMemory() ? "IN MEMORY" : String.valueOf(this.getStoreLocation())) + ", size=" + this.getSize() + "bytes";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.dfos.isInMemory()) {
            this.cachedContent = this.get();
        } else {
            this.cachedContent = null;
            this.dfosFile = this.dfos.getFile();
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        OutputStream output = this.getOutputStream();
        if (this.cachedContent != null) {
            output.write(this.cachedContent);
        } else {
            FileInputStream input = new FileInputStream(this.dfosFile);
            IOUtils.copy((InputStream)input, (OutputStream)output);
            this.dfosFile.delete();
            this.dfosFile = null;
        }
        output.close();
        this.cachedContent = null;
    }
}

