/*
 * Decompiled with CFR 0.152.
 */
package com.github.quintans.ezSQL.transformers;

import com.github.quintans.ezSQL.transformers.MapColumn;
import com.github.quintans.ezSQL.transformers.QueryMapper;
import com.github.quintans.jdbc.exceptions.PersistenceException;
import com.github.quintans.jdbc.transformers.ResultSetWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MapTable {
    private String tableAlias;
    private String associationAlias;
    private String name;
    private List<Object> keys = new ArrayList<Object>();
    private Object instance;
    private List<MapColumn> mapColumns = new ArrayList<MapColumn>();
    private List<MapTable> mapTables = new ArrayList<MapTable>();

    public MapTable(String tableAlias, String name, String associationAlias) {
        this.tableAlias = tableAlias;
        this.associationAlias = associationAlias;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getAssociationAlias() {
        return this.associationAlias;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public Object getInstance() {
        return this.instance;
    }

    public void setInstance(Object instance) {
        this.instance = instance;
    }

    public void addColumnNode(MapColumn mapColumn) {
        if (!this.mapColumns.contains(mapColumn)) {
            this.mapColumns.add(mapColumn);
        }
    }

    public void reset() {
        this.keys = new ArrayList<Object>();
        this.instance = null;
        for (MapTable mapTable : this.mapTables) {
            mapTable.reset();
        }
    }

    public List<MapColumn> getMapColumns() {
        return this.mapColumns;
    }

    public void addTableNode(MapTable mapTable) {
        if (!this.mapTables.contains(mapTable)) {
            this.mapTables.add(mapTable);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapTable mapTable = (MapTable)o;
        return this.tableAlias.equals(mapTable.tableAlias);
    }

    public int hashCode() {
        return Objects.hash(this.tableAlias);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.tableAlias + "." + this.name + " {");
        for (MapColumn cn : this.mapColumns) {
            sb.append(" ").append(cn).append(";");
        }
        sb.append(" } " + this.associationAlias);
        return sb.toString();
    }

    private boolean create(ResultSetWrapper rsw, Object parentInstance, QueryMapper mapper) {
        this.instance = mapper.createFrom(parentInstance, this.associationAlias);
        boolean finalize = false;
        if (mapper.map(rsw, this.instance, this.mapColumns)) {
            finalize = true;
        }
        return finalize;
    }

    public void process(ResultSetWrapper rsw, Map<List<Object>, Object> domainCache, int offset, Object parentInstance, QueryMapper mapper) {
        List<Object> keyValues = null;
        boolean finalize = false;
        if (domainCache != null) {
            keyValues = this.grabKeyValues(rsw, offset);
            if (!keyValues.isEmpty() && !this.keys.equals(keyValues)) {
                this.reset();
                this.instance = domainCache.get(keyValues);
                finalize = this.instance == null ? this.create(rsw, parentInstance, mapper) : true;
                if (finalize) {
                    this.keys = keyValues;
                } else {
                    this.instance = null;
                }
            }
        } else {
            finalize = this.create(rsw, parentInstance, mapper);
        }
        if (finalize && parentInstance != null) {
            mapper.apply(parentInstance, this.associationAlias, this.instance);
        }
        if (this.instance != null) {
            for (MapTable mapTable : this.mapTables) {
                mapTable.process(rsw, domainCache, offset, this.instance, mapper);
            }
        }
    }

    private List<Object> grabKeyValues(ResultSetWrapper rsw, int offset) {
        ArrayList<Object> keyValues = new ArrayList<Object>();
        keyValues.add(this.tableAlias);
        for (MapColumn cn : this.mapColumns) {
            if (!cn.isKey()) continue;
            try {
                ResultSet rs = rsw.getResultSet();
                Object value = rs.getObject(cn.getColumnIndex() + offset);
                if (rs.wasNull()) continue;
                keyValues.add(value);
            }
            catch (SQLException e) {
                throw new PersistenceException((Throwable)e);
            }
        }
        if (keyValues.size() == 1) {
            keyValues.clear();
        }
        return keyValues;
    }
}

