/*
 * Decompiled with CFR 0.152.
 */
package com.github.qzagarese.dockerunit.discovery.consul;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.qzagarese.dockerunit.annotation.ContainerBuilder;
import com.github.qzagarese.dockerunit.annotation.Image;
import com.github.qzagarese.dockerunit.annotation.Named;
import com.github.qzagarese.dockerunit.discovery.consul.annotation.UseConsulDns;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;

@Named(value="consul")
@Image(value="consul:1.0.0")
public class ConsulDescriptor {
    static final int CONSUL_DNS_PORT = 8600;
    static final int CONSUL_PORT = 8500;
    private static final Logger logger = Logger.getLogger(ConsulDescriptor.class.getSimpleName());

    @ContainerBuilder
    public CreateContainerCmd setup(CreateContainerCmd cmd) {
        boolean enableDnsFlag;
        ArrayList<ExposedPort> ports = new ArrayList<ExposedPort>(Arrays.asList(cmd.getExposedPorts()));
        ExposedPort consulPort = ExposedPort.tcp((int)8500);
        ports.add(consulPort);
        Ports bindings = cmd.getPortBindings();
        if (bindings == null) {
            bindings = new Ports();
        }
        if (enableDnsFlag = Boolean.parseBoolean(System.getProperty("consul.dns.enabled", "true"))) {
            this.activateDns(ports, bindings);
        } else {
            logger.warning("Consul DNS has been disabled. Usages of @" + UseConsulDns.class.getSimpleName() + " will be ignored.");
        }
        bindings.bind(consulPort, Ports.Binding.bindPort((int)8500));
        return cmd.withExposedPorts(ports).withPortBindings(bindings).withCmd(new String[]{"agent", "-dev", "-client=0.0.0.0", "-enable-script-checks"});
    }

    private void activateDns(List<ExposedPort> ports, Ports bindings) {
        ExposedPort dnsPort = ExposedPort.udp((int)8600);
        ports.add(dnsPort);
        int dnsBridgePort = Integer.parseInt(System.getProperty("consul.dns.port.bridge.binding", "53"));
        bindings.bind(dnsPort, Ports.Binding.bindIpAndPort((String)System.getProperty("docker.bridge.ip", "172.17.42.1"), (int)dnsBridgePort));
    }
}

