/*
 * Decompiled with CFR 0.152.
 */
package com.github.qzagarese.dockerunit.discovery.consul;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Ports;
import com.github.qzagarese.dockerunit.Service;
import com.github.qzagarese.dockerunit.ServiceContext;
import com.github.qzagarese.dockerunit.ServiceInstance;
import com.github.qzagarese.dockerunit.discovery.DiscoveryProvider;
import com.github.qzagarese.dockerunit.discovery.consul.ConsulDiscoveryConfig;
import com.github.qzagarese.dockerunit.discovery.consul.ConsulHttpResolver;
import com.github.qzagarese.dockerunit.discovery.consul.ServiceRecord;
import com.github.qzagarese.dockerunit.discovery.consul.annotation.EnableConsul;
import com.github.qzagarese.dockerunit.internal.ServiceDescriptor;
import com.github.qzagarese.dockerunit.internal.docker.DefaultDockerClientProvider;
import com.github.qzagarese.dockerunit.internal.service.DefaultServiceContext;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class ConsulDiscoveryProvider
implements DiscoveryProvider {
    private static final String DOCKER_HOST = System.getProperty("docker.host", System.getProperty("docker.bridge.ip", "172.17.42.1"));
    private final ConsulHttpResolver resolver = new ConsulHttpResolver(DOCKER_HOST, 8500);
    private final DockerClient dockerClient;
    private final int discoveryTimeout = Integer.parseInt(System.getProperty("service.discovery.timeout", "30"));
    private final int consulPollingPeriod = Integer.parseInt(System.getProperty("consul.polling.period", "1"));
    static final String CONSUL_DNS_SUFFIX = ".service.consul";

    public ConsulDiscoveryProvider() {
        this.dockerClient = new DefaultDockerClientProvider().getClient();
    }

    public Class<?> getDiscoveryConfig() {
        return ConsulDiscoveryConfig.class;
    }

    public ServiceContext populateRegistry(ServiceContext context) {
        Set services = context.getServices().stream().map(s -> this.doDiscovery((Service)s)).collect(Collectors.toSet());
        return new DefaultServiceContext(services);
    }

    public ServiceContext clearRegistry(ServiceContext currentContext, ServiceContext globalContext) {
        Set services = currentContext.getServices().stream().map(s -> this.doCleanup((Service)s, globalContext.getService(s.getName()))).collect(Collectors.toSet());
        return new DefaultServiceContext(services);
    }

    private Service doDiscovery(Service s) {
        List<ServiceRecord> records;
        try {
            records = this.resolver.resolveService(s.getName(), s.getInstances().size(), this.discoveryTimeout, this.consulPollingPeriod, this.extractInitialDelay(s.getDescriptor()));
        }
        catch (Exception e) {
            return s.withInstances(s.getInstances().stream().map(i -> i.withStatus(ServiceInstance.Status.ABORTED).withStatusDetails(e.getMessage())).collect(Collectors.toSet()));
        }
        Set withPorts = s.getInstances().stream().map(si -> {
            InspectContainerResponse r = this.dockerClient.inspectContainerCmd(si.getContainerId()).exec();
            return si.withPort(this.findPort(r, records)).withIp(DOCKER_HOST).withStatus(ServiceInstance.Status.DISCOVERED).withStatusDetails("Discovered via consul + registrator");
        }).collect(Collectors.toSet());
        return s.withInstances(withPorts);
    }

    private int extractInitialDelay(ServiceDescriptor descriptor) {
        return descriptor.getOptions().stream().filter(EnableConsul.class::isInstance).findFirst().map(EnableConsul.class::cast).map(EnableConsul::initialDelay).orElse(0);
    }

    private Service doCleanup(Service current, Service global) {
        try {
            int expectedRecords = global != null ? global.getInstances().size() : 0;
            this.resolver.verifyCleanup(current.getName() + CONSUL_DNS_SUFFIX, expectedRecords, this.discoveryTimeout, this.consulPollingPeriod);
            return current;
        }
        catch (Exception e) {
            return current.withInstances(current.getInstances().stream().map(si -> si.withStatus(ServiceInstance.Status.TERMINATION_FAILED).withStatusDetails(e.getMessage())).collect(Collectors.toSet()));
        }
    }

    private int findPort(InspectContainerResponse response, List<ServiceRecord> records) {
        ServiceRecord record = records.stream().filter(r -> this.matchPort((ServiceRecord)r, response)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find exposed port/ip for container " + response.getName()));
        return record.getPort();
    }

    private boolean matchPort(ServiceRecord record, InspectContainerResponse r) {
        return r.getNetworkSettings().getPorts().getBindings().values().stream().map(bindings -> Optional.ofNullable(bindings).orElse(new Ports.Binding[0])).filter(b -> ((Ports.Binding[])b).length > 0).map(b -> this.parsePort(b[0].getHostPortSpec())).anyMatch(port -> record.getPort() == port.orElse(-1).intValue());
    }

    private Optional<Integer> parsePort(String s) {
        try {
            return Optional.of(Integer.parseInt(s));
        }
        catch (NumberFormatException nfe) {
            return Optional.empty();
        }
    }
}

