/*
 * Decompiled with CFR 0.152.
 */
package com.github.qzagarese.dockerunit.discovery.consul;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.qzagarese.dockerunit.discovery.consul.ServiceRecord;
import io.vertx.core.Vertx;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;

public class ConsulHttpResolver {
    private final Vertx vertx = Vertx.vertx();
    private final HttpClient httpClient;
    private final String host;
    private final int port;
    private final ObjectMapper mapper = new ObjectMapper();

    public ConsulHttpResolver(String host, int port) {
        this.host = host;
        this.port = port;
        this.httpClient = HttpClientBuilder.create().build();
    }

    public Void verifyCleanup(String serviceName, int expectedRecords, int timeoutInSeconds, int frequencyInSeconds) {
        BiConsumer errorConsumer = (fut, t) -> fut.complete(null);
        BiConsumer matchingConsumer = (fut, records) -> fut.complete(null);
        return (Void)this.performQuerying(serviceName, expectedRecords, timeoutInSeconds, frequencyInSeconds, errorConsumer, matchingConsumer);
    }

    public List<ServiceRecord> resolveService(String serviceName, int expectedRecords, int timeoutInSeconds, int frequencyInSeconds, int initialDelayInSeconds) {
        try {
            Thread.sleep(initialDelayInSeconds * 1000);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Failure occurred during the discovery of service " + serviceName);
        }
        BiConsumer errorConsumer = (fut, t) -> {};
        BiConsumer matchingConsumer = (fut, records) -> fut.complete(records);
        return (List)this.performQuerying(serviceName, expectedRecords, timeoutInSeconds, frequencyInSeconds, errorConsumer, matchingConsumer);
    }

    private <T> T performQuerying(String serviceName, int expectedRecords, int timeoutInSeconds, int frequencyInSeconds, BiConsumer<CompletableFuture<T>, Throwable> errorConsumer, BiConsumer<CompletableFuture<T>, List<ServiceRecord>> matchingConsumer) {
        CompletableFuture result = new CompletableFuture();
        AtomicInteger counter = new AtomicInteger(0);
        this.vertx.setPeriodic((long)(frequencyInSeconds * 1000), timerId -> {
            List<ServiceRecord> records = null;
            try {
                records = this.getHealthyRecords(serviceName);
            }
            catch (Exception e) {
                result.completeExceptionally(e);
            }
            int counterValue = counter.incrementAndGet();
            if (records != null && records.size() == expectedRecords) {
                this.vertx.cancelTimer(timerId.longValue());
                matchingConsumer.accept(result, records);
            } else if (this.timedout(timeoutInSeconds, frequencyInSeconds, counterValue)) {
                this.vertx.cancelTimer(timerId.longValue());
                result.completeExceptionally(new RuntimeException("Discovery timed out."));
            }
        });
        result.exceptionally(ex -> {
            throw new RuntimeException("Discovery/cleanup failed for service " + serviceName);
        });
        return result.join();
    }

    private List<ServiceRecord> getHealthyRecords(String serviceName) throws IOException, ClientProtocolException {
        List<ServiceRecord> allRecords = this.getCatalog(serviceName);
        List<ServiceRecord> unhealthy = this.getUnhealthy(serviceName);
        return allRecords.stream().filter(r -> unhealthy.stream().filter(uh -> uh.getPort() == r.getPort()).collect(Collectors.toList()).size() == 0).collect(Collectors.toList());
    }

    private List<ServiceRecord> getUnhealthy(String serviceName) throws ClientProtocolException, IOException {
        HttpResponse response = null;
        HttpGet get = new HttpGet("http://" + this.host + ":" + this.port + "/v1/health/service/" + serviceName);
        response = this.httpClient.execute((HttpUriRequest)get);
        List<ServiceRecord> records = this.parseUnhealthy(response);
        return records;
    }

    private List<ServiceRecord> getCatalog(String serviceName) throws ClientProtocolException, IOException {
        HttpResponse response = null;
        HttpGet get = new HttpGet("http://" + this.host + ":" + this.port + "/v1/catalog/service/" + serviceName);
        response = this.httpClient.execute((HttpUriRequest)get);
        return (List)this.mapper.reader().forType((TypeReference)new TypeReference<List<ServiceRecord>>(){}).readValue(response.getEntity().getContent());
    }

    private List<ServiceRecord> parseUnhealthy(HttpResponse response) throws UnsupportedOperationException, IOException {
        List records = (List)this.mapper.reader().forType((TypeReference)new TypeReference<List<ServiceRecord>>(){}).readValue(response.getEntity().getContent());
        if (records != null) {
            records = records.stream().filter(r -> {
                List<Object> failingChecks = new ArrayList();
                if (r.getChecks() != null) {
                    failingChecks = r.getChecks().stream().filter(c -> !c.getStatus().equalsIgnoreCase("passing")).collect(Collectors.toList());
                }
                return failingChecks.size() > 0;
            }).collect(Collectors.toList());
        }
        return records;
    }

    private boolean timedout(int timeoutInSeconds, int frequencyInSeconds, int counterValue) {
        return counterValue * frequencyInSeconds >= timeoutInSeconds;
    }
}

