/*
 * Decompiled with CFR 0.152.
 */
package com.github.qzagarese.dockerunit.discovery.consul;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ServiceRecord {
    @JsonProperty(value="ServiceName")
    private final String name;
    @JsonProperty(value="Address")
    private final String address;
    @JsonProperty(value="ServicePort")
    private final int port;
    @JsonProperty(value="Service")
    private final Service service;
    @JsonProperty(value="Checks")
    private final List<Check> checks;

    public String getName() {
        return this.service != null ? this.service.getName() : this.name;
    }

    public String getAddress() {
        return this.service != null ? this.service.getAddress() : this.address;
    }

    public int getPort() {
        return this.service != null ? this.service.getPort() : this.port;
    }

    public ServiceRecord withName(String name) {
        return this.name == name ? this : new ServiceRecord(name, this.address, this.port, this.service, this.checks);
    }

    public ServiceRecord withAddress(String address) {
        return this.address == address ? this : new ServiceRecord(this.name, address, this.port, this.service, this.checks);
    }

    public ServiceRecord withPort(int port) {
        return this.port == port ? this : new ServiceRecord(this.name, this.address, port, this.service, this.checks);
    }

    public ServiceRecord withService(Service service) {
        return this.service == service ? this : new ServiceRecord(this.name, this.address, this.port, service, this.checks);
    }

    public ServiceRecord withChecks(List<Check> checks) {
        return this.checks == checks ? this : new ServiceRecord(this.name, this.address, this.port, this.service, checks);
    }

    public Service getService() {
        return this.service;
    }

    public List<Check> getChecks() {
        return this.checks;
    }

    @ConstructorProperties(value={"name", "address", "port", "service", "checks"})
    public ServiceRecord(String name, String address, int port, Service service, List<Check> checks) {
        this.name = name;
        this.address = address;
        this.port = port;
        this.service = service;
        this.checks = checks;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Check {
        public static final String PASSING = "passing";
        @JsonProperty(value="Name")
        private final String name;
        @JsonProperty(value="Status")
        private final String status;

        public Check withName(String name) {
            return this.name == name ? this : new Check(name, this.status);
        }

        public Check withStatus(String status) {
            return this.status == status ? this : new Check(this.name, status);
        }

        public String getName() {
            return this.name;
        }

        public String getStatus() {
            return this.status;
        }

        @ConstructorProperties(value={"name", "status"})
        public Check(String name, String status) {
            this.name = name;
            this.status = status;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Service {
        @JsonProperty(value="Service")
        private final String name;
        @JsonProperty(value="Address")
        private final String address;
        @JsonProperty(value="Port")
        private final int port;

        public Service withName(String name) {
            return this.name == name ? this : new Service(name, this.address, this.port);
        }

        public Service withAddress(String address) {
            return this.address == address ? this : new Service(this.name, address, this.port);
        }

        public Service withPort(int port) {
            return this.port == port ? this : new Service(this.name, this.address, port);
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public int getPort() {
            return this.port;
        }

        @ConstructorProperties(value={"name", "address", "port"})
        public Service(String name, String address, int port) {
            this.name = name;
            this.address = address;
            this.port = port;
        }
    }
}

