/*
 * Decompiled with CFR 0.152.
 */
package com.github.qzagarese.dockerunit.discovery.consul.annotation.impl;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.qzagarese.dockerunit.annotation.ExtensionInterpreter;
import com.github.qzagarese.dockerunit.discovery.consul.annotation.EnableConsul;
import com.github.qzagarese.dockerunit.internal.ServiceDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class EnableConsulExtensionInterpreter
implements ExtensionInterpreter<EnableConsul> {
    private static final String SERVICE_NAME_SUFFIX = "_NAME";
    private static final String SERVICE_PREFIX = "SERVICE_";
    private static final String SERVICE_CHECK_INTERVAL = "SERVICE_CHECK_INTERVAL";
    private static final String SERVICE_CHECK_INITIAL_STATUS = "SERVICE_CHECK_INITIAL_STATUS";

    public CreateContainerCmd build(ServiceDescriptor td, CreateContainerCmd cmd, EnableConsul ec) {
        String serviceNameEnv = SERVICE_PREFIX + ec.exposedPort() + SERVICE_NAME_SUFFIX + "=" + td.getNamed().value();
        String serviceCheckIntervalEnv = "SERVICE_CHECK_INTERVAL=" + ec.pollingInterval() + "s";
        String serviceInitialStatusEnv = "SERVICE_CHECK_INITIAL_STATUS=" + ec.checkInitialStatus().toString().toLowerCase();
        ArrayList<String> finalEnv = new ArrayList<String>();
        List<String> enableConsulEnv = Arrays.asList(serviceNameEnv, serviceCheckIntervalEnv, serviceInitialStatusEnv);
        finalEnv.addAll(enableConsulEnv);
        String[] env = cmd.getEnv();
        if (env != null) {
            finalEnv.addAll(Arrays.asList(env));
        }
        return cmd.withEnv(finalEnv);
    }
}

