/*
 * Decompiled with CFR 0.152.
 */
package com.github.qzagarese.dockerunit.discovery.consul.annotation.impl;

import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.qzagarese.dockerunit.annotation.ExtensionInterpreter;
import com.github.qzagarese.dockerunit.discovery.consul.annotation.WebHealthCheck;
import com.github.qzagarese.dockerunit.internal.ServiceDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class WebHealthCheckExtensionInterpreter
implements ExtensionInterpreter<WebHealthCheck> {
    private static final String SERVICE_NAME_SUFFIX = "_NAME";
    private static final String SERVICE_PREFIX = "SERVICE_";
    private static final String SERVICE_CHECK_SCRIPT = "SERVICE_CHECK_SCRIPT";
    private static final String SERVICE_CHECK_INTERVAL = "SERVICE_CHECK_INTERVAL";

    public CreateContainerCmd build(ServiceDescriptor td, CreateContainerCmd cmd, WebHealthCheck whc) {
        String serviceNameEnv = SERVICE_PREFIX + whc.exposedPort() + SERVICE_NAME_SUFFIX + "=" + td.getNamed().value();
        String serviceCheckScriptEnv = "SERVICE_CHECK_SCRIPT=`which curl` -f " + (whc.protocol().equals((Object)WebHealthCheck.WebProtocol.HTTPS) ? "-sSk " : "") + whc.protocol().toString().toLowerCase() + "://$SERVICE_IP:$SERVICE_PORT" + whc.endpoint();
        String serviceCheckIntervalEnv = "SERVICE_CHECK_INTERVAL=" + whc.pollingInterval() + "s";
        ArrayList<String> finalEnv = new ArrayList<String>();
        List<String> healthCheckEnv = Arrays.asList(serviceNameEnv, serviceCheckScriptEnv, serviceCheckIntervalEnv);
        finalEnv.addAll(healthCheckEnv);
        String[] env = cmd.getEnv();
        if (env != null) {
            finalEnv.addAll(Arrays.asList(env));
        }
        return cmd.withEnv(finalEnv);
    }
}

