/*
 * Decompiled with CFR 0.152.
 */
package com.rmz.cryptoutil;

import com.rmz.cryptoutil.Rfc2898DeriveBytes;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtil {
    private Cipher ecipher;
    private Cipher dcipher;
    private static String cryptKey = "standartkey";

    private static byte[] salt() {
        return new byte[]{73, 118, 97, 110, 32, 77, 101, 100, 118, 101, 100, 101, 118};
    }

    public CryptoUtil() {
        this(cryptKey, CryptoUtil.salt());
    }

    public CryptoUtil(String keyString) {
        this(keyString, CryptoUtil.salt());
    }

    public CryptoUtil(String keyString, byte[] salt) {
        try {
            this.setSecretKey(keyString, salt);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | InvalidParameterSpecException | NoSuchPaddingException ex) {
            throw new IllegalArgumentException("Incorrent format keyString or salt!", ex);
        }
    }

    private void setSecretKey(String keyString, byte[] salt) throws InvalidParameterSpecException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeyException, NoSuchPaddingException, InvalidKeySpecException, UnsupportedEncodingException {
        Rfc2898DeriveBytes keyGenerator = new Rfc2898DeriveBytes(keyString, salt);
        byte[] keyBytes = keyGenerator.getBytes(32);
        byte[] ivBytes = keyGenerator.getBytes(16);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, "AES");
        this.ecipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        this.ecipher.init(1, (Key)secretKeySpec, new IvParameterSpec(ivBytes));
        this.dcipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        this.dcipher.init(2, (Key)secretKeySpec, new IvParameterSpec(ivBytes));
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes(StandardCharsets.UTF_16LE);
            byte[] enc = this.ecipher.doFinal(utf8);
            return Base64.getEncoder().encodeToString(enc);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(CryptoUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public String decrypt(String str) {
        try {
            byte[] dec = Base64.getDecoder().decode(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, StandardCharsets.UTF_16LE);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            Logger.getLogger(CryptoUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

