/*
 * Decompiled with CFR 0.152.
 */
package com.github.rahulsom.cda;

import com.github.rahulsom.cda.CE;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CcdSections {
    public static final String DCM = "2.16.840.1.113883.10.20.6.1.1";
    public static final String LOINC = "2.16.840.1.113883.6.1";
    private static final Map<String, String> codeSystemNames = new HashMap<String, String>();
    private static final List<CE> sections;
    public static final CE AdvanceDirectives;
    public static final CE Addendum;
    public static final CE Allergies;
    public static final CE Anesthesia;
    public static final CE Assessment;
    public static final CE AssessmentAndPlan;
    public static final CE ChiefComplaint;
    public static final CE ChiefComplaintAndReasonForVisit;
    public static final CE ClinicalPresentation;
    public static final CE Complications;
    public static final CE Conclusions;
    public static final CE CurrentImagingProcedureDescriptions;
    public static final CE DicomObjectCatalog;
    public static final CE DischargeDiet;
    public static final CE DocumentSummary;
    public static final CE Encounters;
    public static final CE FamilyHistory;
    public static final CE FindingsRadiologyStudyObservation;
    public static final CE FunctionalStatus;
    public static final CE GeneralStatus;
    public static final CE HistoryOfPastIllnessPastMedicalHistory;
    public static final CE HistoryOfPresentIllness;
    public static final CE HospitalAdmissionDiagnosis;
    public static final CE HospitalConsultation;
    public static final CE HospitalCourse;
    public static final CE HospitalDischargeDiagnosis;
    public static final CE HospitalDischargeInstructions;
    public static final CE HospitalDischargeMedications;
    public static final CE HospitalDischargePhysical;
    public static final CE HospitalDischargeStudiesSummary;
    public static final CE Immunizations;
    public static final CE Interventions;
    public static final CE KeyImages;
    public static final CE MedicalEquipment;
    public static final CE MedicalGeneralHistory;
    public static final CE Medications;
    public static final CE MedicationsAdministered;
    public static final CE Objective;
    public static final CE OperativeNoteFluids;
    public static final CE OperativeNoteSurgicalProcedure;
    public static final CE Payers;
    public static final CE PhysicalExam;
    public static final CE PlanOfCare;
    public static final CE PlannedProcedure;
    public static final CE PostOperativeDiagnosis;
    public static final CE PostProcedureDiagnosis;
    public static final CE PreoperativeDiagnosis;
    public static final CE PriorImagingProcedureDescriptions;
    public static final CE Problem;
    public static final CE ProcedureDescription;
    public static final CE ProcedureDisposition;
    public static final CE ProcedureEstimatedBloodLoss;
    public static final CE ProcedureFindings;
    public static final CE ProcedureImplants;
    public static final CE ProcedureIndications;
    public static final CE ProcedureSpecimensTaken;
    public static final CE ProceduresListOfSurgeriesHistoryOfProcedures;
    public static final CE RadiologyComparisonStudyObservation;
    public static final CE RadiologyImpression;
    public static final CE RadiologyStudyRecommendations;
    public static final CE RadiologyReasonForStudy;
    public static final CE ReasonForReferral;
    public static final CE ReasonForVisit;
    public static final CE RequestedImagingStudiesInformation;
    public static final CE Results;
    public static final CE ReviewOfSystems;
    public static final CE SocialHistory;
    public static final CE Subjective;
    public static final CE SurgicalDrains;
    public static final CE VitalSigns;

    private static CE code(String code, String displayName, String oid) {
        String codeSystemName = codeSystemNames.get(oid);
        CE ce = new CE().withCode(code).withDisplayName(displayName).withCodeSystem(oid).withCodeSystemName(codeSystemName);
        sections.add(ce);
        return ce;
    }

    public static CE find(String codeSystem, String code) {
        for (CE section : sections) {
            if (!section.getCode().equals(code) || !section.getCodeSystem().equals(codeSystem)) continue;
            return section;
        }
        return null;
    }

    static {
        codeSystemNames.put(DCM, "DCM");
        codeSystemNames.put(LOINC, "LOINC");
        sections = new ArrayList<CE>();
        AdvanceDirectives = CcdSections.code("42348-3", "Advance Directives", LOINC);
        Addendum = CcdSections.code("55107-7", "Addendum", LOINC);
        Allergies = CcdSections.code("48765-2", "Allergies", LOINC);
        Anesthesia = CcdSections.code("59774-0", "Anesthesia", LOINC);
        Assessment = CcdSections.code("51848-0", "Assessment", LOINC);
        AssessmentAndPlan = CcdSections.code("51847-2", "Assessment and Plan", LOINC);
        ChiefComplaint = CcdSections.code("10154-3", "Chief Complaint", LOINC);
        ChiefComplaintAndReasonForVisit = CcdSections.code("46239-0", "Chief Complaint and Reason for Visit", LOINC);
        ClinicalPresentation = CcdSections.code("55108-5", "Clinical Presentation", LOINC);
        Complications = CcdSections.code("55109-3", "Complications", LOINC);
        Conclusions = CcdSections.code("55110-1", "Conclusions", LOINC);
        CurrentImagingProcedureDescriptions = CcdSections.code("55111-9", "Current Imaging Procedure Descriptions", LOINC);
        DicomObjectCatalog = CcdSections.code("121181", "DICOM Object Catalog", DCM);
        DischargeDiet = CcdSections.code("42344-2", "Discharge Diet", LOINC);
        DocumentSummary = CcdSections.code("55112-7", "Document Summary", LOINC);
        Encounters = CcdSections.code("46240-8", "Encounters", LOINC);
        FamilyHistory = CcdSections.code("10157-6", "Family History", LOINC);
        FindingsRadiologyStudyObservation = CcdSections.code("18782-3", "Findings (Radiology Study - Observation)", LOINC);
        FunctionalStatus = CcdSections.code("47420-5", "Functional Status", LOINC);
        GeneralStatus = CcdSections.code("10210-3", "General Status", LOINC);
        HistoryOfPastIllnessPastMedicalHistory = CcdSections.code("11348-0", "History of Past Illness (Past Medical History)", LOINC);
        HistoryOfPresentIllness = CcdSections.code("10164-2", "History of Present Illness", LOINC);
        HospitalAdmissionDiagnosis = CcdSections.code("46241-6", "Hospital Admission Diagnosis", LOINC);
        HospitalConsultation = CcdSections.code("18841-7", "Hospital Consultation", LOINC);
        HospitalCourse = CcdSections.code("8648-8", "Hospital Course", LOINC);
        HospitalDischargeDiagnosis = CcdSections.code("11535-2", "Hospital Discharge Diagnosis", LOINC);
        HospitalDischargeInstructions = CcdSections.code("8653-8", "Hospital Discharge Instructions", LOINC);
        HospitalDischargeMedications = CcdSections.code("10183-2", "Hospital Discharge Medications", LOINC);
        HospitalDischargePhysical = CcdSections.code("10184-0", "Hospital Discharge Physical", LOINC);
        HospitalDischargeStudiesSummary = CcdSections.code("11493-4", "Hospital Discharge Studies Summary", LOINC);
        Immunizations = CcdSections.code("11369-6", "Immunizations", LOINC);
        Interventions = CcdSections.code("62387-6", "Interventions", LOINC);
        KeyImages = CcdSections.code("55113-5", "Key Images", LOINC);
        MedicalEquipment = CcdSections.code("46264-8", "Medical Equipment", LOINC);
        MedicalGeneralHistory = CcdSections.code("11329-0", "Medical (General) History", LOINC);
        Medications = CcdSections.code("10160-0", "Medications", LOINC);
        MedicationsAdministered = CcdSections.code("29549-3", "Medications Administered ", LOINC);
        Objective = CcdSections.code("61149-1", "Objective", LOINC);
        OperativeNoteFluids = CcdSections.code("10216-0", "Operative Note Fluids", LOINC);
        OperativeNoteSurgicalProcedure = CcdSections.code("10223-6", "Operative Note Surgical Procedure", LOINC);
        Payers = CcdSections.code("48768-6", "Payers", LOINC);
        PhysicalExam = CcdSections.code("29545-1", "Physical Exam", LOINC);
        PlanOfCare = CcdSections.code("18776-5", "Plan of Care", LOINC);
        PlannedProcedure = CcdSections.code("59772-4", "Planned Procedure", LOINC);
        PostOperativeDiagnosis = CcdSections.code("10218-6", "Post-operative Diagnosis", LOINC);
        PostProcedureDiagnosis = CcdSections.code("59769-0", "Post-procedure Diagnosis", LOINC);
        PreoperativeDiagnosis = CcdSections.code("10219-4", "Preoperative Diagnosis", LOINC);
        PriorImagingProcedureDescriptions = CcdSections.code("55114-3", "Prior Imaging Procedure Descriptions", LOINC);
        Problem = CcdSections.code("11450-4", "Problem ", LOINC);
        ProcedureDescription = CcdSections.code("29554-3", "Procedure Description", LOINC);
        ProcedureDisposition = CcdSections.code("59775-7", "Procedure Disposition", LOINC);
        ProcedureEstimatedBloodLoss = CcdSections.code("59770-8", "Procedure Estimated Blood Loss", LOINC);
        ProcedureFindings = CcdSections.code("59776-5", "Procedure Findings", LOINC);
        ProcedureImplants = CcdSections.code("59771-6", "Procedure Implants", LOINC);
        ProcedureIndications = CcdSections.code("59768-2", "Procedure Indications ", LOINC);
        ProcedureSpecimensTaken = CcdSections.code("59773-2", "Procedure Specimens Taken", LOINC);
        ProceduresListOfSurgeriesHistoryOfProcedures = CcdSections.code("47519-4", "Procedures List of Surgeries (History of Procedures) ", LOINC);
        RadiologyComparisonStudyObservation = CcdSections.code("18834-2", "Radiology Comparison Study \u2013 Observation", LOINC);
        RadiologyImpression = CcdSections.code("19005-8", "Radiology \u2013 Impression", LOINC);
        RadiologyStudyRecommendations = CcdSections.code("18783-1", "Radiology Study \u2013 Recommendations", LOINC);
        RadiologyReasonForStudy = CcdSections.code("18785-6", "Radiology Reason for Study", LOINC);
        ReasonForReferral = CcdSections.code("42349-1", "Reason for Referral", LOINC);
        ReasonForVisit = CcdSections.code("29299-5", "Reason for Visit", LOINC);
        RequestedImagingStudiesInformation = CcdSections.code("55115-0", "Requested Imaging Studies Information", LOINC);
        Results = CcdSections.code("30954-2", "Results", LOINC);
        ReviewOfSystems = CcdSections.code("10187-3", "Review of Systems", LOINC);
        SocialHistory = CcdSections.code("29762-2", "Social History", LOINC);
        Subjective = CcdSections.code("61150-9", "Subjective ", LOINC);
        SurgicalDrains = CcdSections.code("11537-8", "Surgical Drains", LOINC);
        VitalSigns = CcdSections.code("8716-3", "Vital Signs ", LOINC);
    }
}

