/*
 * Decompiled with CFR 0.152.
 */
package com.github.rahulsom.iheiti;

import java.io.Serializable;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.hl7.v3.AD;
import org.hl7.v3.ADXP;
import org.hl7.v3.AdxpCity;
import org.hl7.v3.AdxpCountry;
import org.hl7.v3.AdxpPostalCode;
import org.hl7.v3.AdxpState;
import org.hl7.v3.AdxpStreetAddressLine;
import org.hl7.v3.CD;
import org.hl7.v3.CE;
import org.hl7.v3.CS;
import org.hl7.v3.EN;
import org.hl7.v3.ENXP;
import org.hl7.v3.EnFamily;
import org.hl7.v3.EnGiven;
import org.hl7.v3.II;
import org.hl7.v3.INT;
import org.hl7.v3.PN;
import org.hl7.v3.ST;
import org.hl7.v3.TS;

public class ItiHelper {
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String DATE_TIME_FORMAT = "yyyyMMddHHmmss";

    public static <T> JAXBElement<T> jaxb(String tagname, Class<T> clazz, T value) {
        return new JAXBElement(new QName("urn:hl7-org:v3", tagname), clazz, value);
    }

    public static TS ts(String value) {
        return new TS().withValue(value);
    }

    public static TS ts(Date value, String format) {
        return ItiHelper.ts(new SimpleDateFormat(format).format(value));
    }

    public static TS ts(Date value) {
        return ItiHelper.ts(value, DATE_TIME_FORMAT);
    }

    public static ST st(String value) {
        return new ST().withContent(new Serializable[]{value});
    }

    public static INT intOf(BigInteger value) {
        return new INT().withValue(value);
    }

    public static INT intOf(int value) {
        return new INT().withValue(BigInteger.valueOf(value));
    }

    public static II ii(String root, String extension, String namespace) {
        return new II().withRoot(root).withExtension(extension).withAssigningAuthorityName(namespace);
    }

    public static II ii(String root, String extension) {
        return ItiHelper.ii(root, extension, null);
    }

    public static II ii(String root) {
        return ItiHelper.ii(root, null, null);
    }

    public static CS cs(String code, String codeSystem) {
        return new CS().withCode(code).withCodeSystem(codeSystem);
    }

    public static CS cs(String code) {
        return ItiHelper.cs(code, null);
    }

    public static CD cd(String code, String codeSystem) {
        return new CD().withCode(code).withCodeSystem(codeSystem);
    }

    public static CD cd(String code) {
        return ItiHelper.cd(code, null);
    }

    public static CE ce(String code) {
        return new CE().withCode(code);
    }

    public static PN pn(Collection<JAXBElement<? extends ENXP>> data) {
        ArrayList<JAXBElement<? extends ENXP>> arg = new ArrayList<JAXBElement<? extends ENXP>>();
        arg.addAll(data);
        return new PN().withContent(arg);
    }

    public static EN en(Collection<JAXBElement<? extends ENXP>> data) {
        ArrayList<Serializable> arg = new ArrayList<Serializable>();
        arg.addAll(data);
        return new EN().withContent((Collection<Serializable>)arg);
    }

    public static AD ad(Collection<JAXBElement<? extends ADXP>> data) {
        ArrayList<Serializable> arg = new ArrayList<Serializable>();
        arg.addAll(data);
        return new AD().withContent((Collection<Serializable>)arg);
    }

    public static PN pn(JAXBElement<? extends ENXP> ... data) {
        return new PN().withContent((Serializable[])data);
    }

    public static EN en(JAXBElement<? extends ENXP> ... data) {
        return new EN().withContent((Serializable[])data);
    }

    public static AD ad(JAXBElement<? extends ADXP> ... data) {
        return new AD().withContent((Serializable[])data);
    }

    public static class Ad {
        public static JAXBElement<AdxpStreetAddressLine> streetAddressLine(String value) {
            return ItiHelper.jaxb("streetAddressLine", AdxpStreetAddressLine.class, new AdxpStreetAddressLine().withContent(new Serializable[]{value}));
        }

        public static JAXBElement<AdxpCity> city(String value) {
            return ItiHelper.jaxb("city", AdxpCity.class, new AdxpCity().withContent(new Serializable[]{value}));
        }

        public static JAXBElement<AdxpState> state(String value) {
            return ItiHelper.jaxb("state", AdxpState.class, new AdxpState().withContent(new Serializable[]{value}));
        }

        public static JAXBElement<AdxpCountry> country(String value) {
            return ItiHelper.jaxb("country", AdxpCountry.class, new AdxpCountry().withContent(new Serializable[]{value}));
        }

        public static JAXBElement<AdxpPostalCode> postalCode(String value) {
            return ItiHelper.jaxb("postalCode", AdxpPostalCode.class, new AdxpPostalCode().withContent(new Serializable[]{value}));
        }
    }

    public static class En {
        public static JAXBElement<EnGiven> given(String value) {
            return ItiHelper.jaxb("given", EnGiven.class, new EnGiven().withContent(new Serializable[]{value}));
        }

        public static JAXBElement<EnFamily> family(String value) {
            return ItiHelper.jaxb("family", EnFamily.class, new EnFamily().withContent(new Serializable[]{value}));
        }
    }
}

