/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonparser;

import com.github.jsonparser.exception.JsonParsingException;
import com.github.jsonparser.reader.JsonReader;
import com.github.jsonparser.util.ValidationUtil;
import com.github.jsonparser.writer.CsvWriter;
import java.io.Writer;
import java.util.List;
import java.util.logging.Logger;

public class JsonParser {
    public static final Logger log = Logger.getLogger(JsonParser.class.getName());

    private JsonParser() {
    }

    public static String parse2Csv(String json) throws JsonParsingException {
        log.info("Received request to parse json to csv.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Sheet(json));
        return CsvWriter.write2String(records);
    }

    public static void parse2Csv(String json, String csvFilePath) throws JsonParsingException {
        ValidationUtil.rejectNull(csvFilePath, "csv file path");
        log.info("Received request to parse json to csv.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Sheet(json));
        CsvWriter.write2csv(records, csvFilePath);
    }

    public static void parse2Csv(String json, Writer writer) throws JsonParsingException {
        ValidationUtil.rejectNull(writer, "writer");
        log.info("Received request to parse json to csv.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Sheet(json));
        CsvWriter.write(records, writer);
    }

    public static String parse2Csv(String json, String separator, String delimiter) throws JsonParsingException {
        if (separator == null) {
            separator = "_";
        }
        if (delimiter == null) {
            delimiter = ",";
        }
        log.info("Received request to parse json to csv.");
        List<Object[]> records = JsonReader.parse(json, separator);
        return CsvWriter.write2String(records, delimiter);
    }

    public static void parse2Csv(String json, String csvFilePath, String separator, String delimiter) throws JsonParsingException {
        ValidationUtil.rejectNull(csvFilePath, "csv file path");
        if (separator == null) {
            separator = "_";
        }
        if (delimiter == null) {
            delimiter = ",";
        }
        log.info("Received request to parse json to csv.");
        List<Object[]> records = JsonReader.parse(json, separator);
        CsvWriter.write2csv(records, csvFilePath, delimiter);
    }

    public static void parse2Csv(String json, Writer writer, String separator, String delimiter) throws JsonParsingException {
        ValidationUtil.rejectNull(writer, "writer");
        if (separator == null) {
            separator = "_";
        }
        if (delimiter == null) {
            delimiter = ",";
        }
        log.info("Received request to parse json to csv.");
        List<Object[]> records = JsonReader.parse(json, separator);
        CsvWriter.write(records, writer, delimiter);
    }

    public static String parseXsd2Csv(String json) throws JsonParsingException {
        log.info("Received request to parse xsd json string to csv.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Header(json));
        return CsvWriter.write2String(records);
    }

    public static void parseXsd2Csv(String json, String csvFilePath) throws JsonParsingException {
        ValidationUtil.rejectNull(csvFilePath, "csv file path");
        log.info("Received request to parse xsd json string to csv.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Header(json));
        CsvWriter.write2csv(records, csvFilePath);
    }

    public static void parseXsd2Csv(String json, Writer writer) throws JsonParsingException {
        ValidationUtil.rejectNull(writer, "writer");
        log.info("Received request to parse xsd json string to csv.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Header(json));
        CsvWriter.write(records, writer);
    }

    public static String parse2CsvWithXsd(String json, String xsdSchema) throws JsonParsingException {
        ValidationUtil.rejectNull(xsdSchema, "xsd schema");
        log.info("Received request to parse json string to csv with xsd.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Sheet(json, xsdSchema));
        return CsvWriter.write2String(records);
    }

    public static void parse2CsvWithXsd(String json, String xsdSchema, String csvFilePath) throws JsonParsingException {
        ValidationUtil.rejectNull(xsdSchema, "xsd schema");
        log.info("Received request to parse json string to csv with xsd.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Sheet(json, xsdSchema));
        CsvWriter.write2csv(records, csvFilePath);
    }

    public static void parse2CsvWithXsd(String json, String xsdSchema, Writer writer) throws JsonParsingException {
        ValidationUtil.rejectNull(xsdSchema, "xsd schema");
        ValidationUtil.rejectNull(writer, "writer");
        log.info("Received request to parse json string to csv with xsd.");
        List<Object[]> records = JsonReader.parse(json, JsonReader.json2Sheet(json, xsdSchema));
        CsvWriter.write(records, writer);
    }
}

