/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonparser.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonOrder {
    private static Type type = new TypeToken<Map<String, Object>>(){}.getType();
    private static Gson gson;

    public static JsonElement orderJson(JsonElement ele) {
        LinkedHashMap jsonPre = new LinkedHashMap();
        LinkedHashMap jsonArr = new LinkedHashMap();
        LinkedHashMap jsonObj = new LinkedHashMap();
        Map origMap = (Map)gson.fromJson(ele, type);
        for (Map.Entry entry : origMap.entrySet()) {
            try {
                if (entry.getValue() == null || entry.getValue().getClass().getSimpleName().equals("ArrayList")) {
                    jsonArr.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (entry.getValue().getClass().getSimpleName().equals("LinkedTreeMap")) {
                    jsonObj.put(entry.getKey(), entry.getValue());
                    continue;
                }
                jsonPre.put(entry.getKey(), entry.getValue());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        jsonPre.putAll(jsonObj);
        jsonPre.putAll(jsonArr);
        return gson.toJsonTree(jsonPre, LinkedHashMap.class);
    }

    private static JsonElement serialize(Double src, Type typeOfSrc, JsonSerializationContext context) {
        if (src == (double)src.longValue()) {
            return new JsonPrimitive((Number)src.longValue());
        }
        return new JsonPrimitive((Number)src);
    }

    static {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(Double.class, JsonOrder::serialize);
        gson = gsonBuilder.create();
    }
}

