/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonparser.reader;

import com.github.jsonparser.exception.JsonParsingException;
import com.github.jsonparser.model.JsonOrder;
import com.github.jsonparser.util.ValidationUtil;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class JsonReader {
    public static final Logger log = Logger.getLogger(JsonReader.class.getName());
    private static final Set<String> DATA_TYPES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Boolean", "Integer", "String", "Double", "Long")));

    private JsonReader() {
    }

    public static List<Object[]> parse(String json, List<Object[]> records) throws JsonParsingException {
        ValidationUtil.rejectNull(json, "json");
        JsonReader.headerSeparator(records);
        return records;
    }

    public static List<Object[]> parse(String json, String separator) throws JsonParsingException {
        ValidationUtil.rejectNull(json, "json");
        List<Object[]> records = JsonReader.json2Sheet(json);
        JsonReader.headerSeparator(records, separator);
        return records;
    }

    public static List<Object[]> json2Sheet(String json) {
        return JsonReader.processJson(json, null);
    }

    public static List<Object[]> json2Sheet(String json, String xsd) {
        return JsonReader.processJson(json, xsd);
    }

    public static List<Object[]> json2Header(String json) {
        log.info("Processing input xsd json to 2D representation.");
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        JsonReader.configureAndBuildHeader(json, records);
        log.info("Returning processed headers/columns records.");
        return records;
    }

    private static List<Object[]> processJson(String json, String xsd) {
        log.info("Processing input json to 2D representation.");
        ArrayList<Object[]> records = new ArrayList<Object[]>();
        ArrayList<String> headers = xsd == null ? JsonReader.configureAndBuildHeader(json, records) : JsonReader.configureAndBuildHeader(xsd, records);
        JsonElement ele = JsonParser.parseString((String)json);
        records.add(JsonReader.buildCsv(new Object[headers.size()], ele, "$", headers, records));
        JsonReader.removeDuplicates(records);
        log.info("Returning processed list of records.");
        return records;
    }

    private static void removeDuplicates(List<Object[]> records) {
        if (records.size() > 2) {
            Object[] last = records.get(records.size() - 1);
            Object[] secondLast = records.get(records.size() - 2);
            boolean delete = Arrays.stream(last).noneMatch(Objects::nonNull);
            if (!delete) {
                delete = true;
                if (IntStream.range(0, last.length).anyMatch(DEL -> last[DEL] != null && !last[DEL].equals(secondLast[DEL]))) {
                    delete = false;
                }
            }
            if (delete) {
                records.remove(records.size() - 1);
            }
        }
    }

    private static ArrayList<String> configureAndBuildHeader(String json, List<Object[]> records) {
        log.info("Setting the default configuration for json processing.");
        JsonReader.setDefaultConfiguration();
        Configuration conf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.DEFAULT_PATH_LEAF_TO_NULL}).addOptions(new Option[]{Option.SUPPRESS_EXCEPTIONS});
        Configuration pathConf = Configuration.defaultConfiguration().addOptions(new Option[]{Option.AS_PATH_LIST}).addOptions(new Option[]{Option.ALWAYS_RETURN_LIST});
        List pathList = (List)JsonPath.using((Configuration)pathConf).parse(json).read("$..*", new Predicate[0]);
        DocumentContext context = JsonPath.using((Configuration)conf).parse(json);
        HashSet<String> primitivePaths = JsonReader.extractPrimitivePaths(context, pathList);
        HashSet uniquePrimitivePaths = primitivePaths.stream().map(JsonReader::evaluatePath).collect(Collectors.toCollection(LinkedHashSet::new));
        ArrayList<String> uniqueHeaders = new ArrayList<String>(uniquePrimitivePaths);
        JsonReader.addHeaders(uniqueHeaders, records);
        log.info("Returning the header/column list.");
        return uniqueHeaders;
    }

    private static void setDefaultConfiguration() {
        Configuration.setDefaults((Configuration.Defaults)new Configuration.Defaults(){
            private final JsonProvider jsonProvider = new JacksonJsonProvider();
            private final MappingProvider mappingProvider = new JacksonMappingProvider();

            public JsonProvider jsonProvider() {
                return this.jsonProvider;
            }

            public MappingProvider mappingProvider() {
                return this.mappingProvider;
            }

            public Set options() {
                return EnumSet.noneOf(Option.class);
            }
        });
    }

    private static HashSet<String> extractPrimitivePaths(DocumentContext parse, List<String> pathList) {
        log.info("Extracting primitive path list from json.");
        LinkedHashSet<String> primitivePaths = new LinkedHashSet<String>();
        pathList.forEach(path -> {
            Object tmp = parse.read(path, new Predicate[0]);
            if (tmp == null) {
                primitivePaths.add((String)path);
            } else {
                String dataType = tmp.getClass().getSimpleName();
                if (DATA_TYPES.contains(dataType)) {
                    primitivePaths.add((String)path);
                }
            }
        });
        log.info("Returning extracted primitive path list from json.");
        return primitivePaths;
    }

    private static void addHeaders(List<String> unique, List<Object[]> records) {
        Object[] headers = new Object[unique.size()];
        int i = 0;
        for (String header : unique) {
            headers[i] = header;
            ++i;
        }
        records.add(headers);
    }

    private static Object[] buildCsv(Object[] old, JsonElement ele, String path, List<String> headers, List<Object[]> records) {
        Object[] cur;
        block11: {
            block10: {
                cur = (Object[])old.clone();
                if (!ele.isJsonObject()) break block10;
                ele = JsonOrder.orderJson(ele);
                for (Map.Entry entry : ele.getAsJsonObject().entrySet()) {
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        String tmpPath = path + "['" + (String)entry.getKey() + "']";
                        JsonReader.evaluateTempPath(cur, entry, tmpPath, headers);
                        continue;
                    }
                    if (((JsonElement)entry.getValue()).isJsonObject()) {
                        cur = JsonReader.buildCsv(cur, (JsonElement)((JsonElement)entry.getValue()).getAsJsonObject(), path + "['" + (String)entry.getKey() + "']", headers, records);
                        continue;
                    }
                    if (!((JsonElement)entry.getValue()).isJsonArray()) continue;
                    cur = JsonReader.buildCsv(cur, (JsonElement)((JsonElement)entry.getValue()).getAsJsonArray(), path + "['" + (String)entry.getKey() + "']", headers, records);
                }
                break block11;
            }
            if (!ele.isJsonArray()) break block11;
            int arrIndex = 0;
            for (JsonElement jsonElement : ele.getAsJsonArray()) {
                if (jsonElement.isJsonPrimitive()) {
                    String tmpPath = path + "['" + arrIndex + "']";
                    JsonReader.evaluateTempPath(cur, jsonElement, tmpPath, headers);
                } else if (jsonElement.isJsonObject()) {
                    boolean gotArray = JsonReader.isInnerArray(jsonElement);
                    JsonReader.removeDuplicates(records);
                    records.add(JsonReader.buildCsv(cur, (JsonElement)jsonElement.getAsJsonObject(), path + "[" + arrIndex + "]", headers, records));
                    if (gotArray) {
                        records.remove(records.size() - 1);
                    }
                } else if (jsonElement.isJsonArray()) {
                    JsonReader.buildCsv(cur, (JsonElement)jsonElement.getAsJsonArray(), path + "[" + arrIndex + "]", headers, records);
                }
                ++arrIndex;
            }
        }
        return cur;
    }

    private static void evaluateTempPath(Object[] cur, Map.Entry<String, JsonElement> entry, String tmpPath, List<String> headers) {
        if (headers.contains(tmpPath = JsonReader.evaluatePath(tmpPath))) {
            int index = headers.indexOf(tmpPath);
            cur[index] = entry.getValue().getAsJsonPrimitive();
        }
    }

    private static void evaluateTempPath(Object[] cur, JsonElement tmp, String tmpPath, List<String> headers) {
        if (headers.contains(tmpPath = JsonReader.evaluatePath(tmpPath))) {
            int index = headers.indexOf(tmpPath);
            cur[index] = tmp.getAsJsonPrimitive();
        }
    }

    private static String evaluatePath(String path) {
        String str;
        Pattern pattern = Pattern.compile("(\\[[0-9]*\\]$)", 8);
        Matcher matcher = pattern.matcher(path);
        if (matcher.find()) {
            String[] tmp = path.replace("$", "").split("(\\[[0-9]*\\]$)");
            tmp[0] = tmp[0].replaceAll("(\\[[0-9]*\\])", "");
            str = "/" + (tmp[0] + matcher.group()).replace("'][", "/");
        } else {
            str = "/" + path.replace("$", "").replaceAll("(\\[[0-9]*\\])", "");
        }
        return JsonReader.commonReplace(str);
    }

    private static String commonReplace(String str) {
        return str.replace("[", "").replace("]", "").replace("''", "/").replace("'", "");
    }

    private static boolean isInnerArray(JsonElement ele) {
        for (Map.Entry entry : ele.getAsJsonObject().entrySet()) {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (!jsonElement.isJsonArray() || jsonElement.getAsJsonArray().size() <= 0) continue;
            for (JsonElement checkPrimitive : jsonElement.getAsJsonArray()) {
                if (!checkPrimitive.isJsonObject()) continue;
                return true;
            }
        }
        return false;
    }

    private static void headerSeparator(List<Object[]> records) {
        JsonReader.headerSeparator(records, "_");
    }

    private static void headerSeparator(List<Object[]> records, String separator) {
        log.info(String.format("Updating header/column values with separator \"%s\"", separator));
        IntStream.range(0, records.get(0).length).forEach(I -> {
            ((Object[])records.get((int)0))[I] = ((Object[])records.get(0))[I].toString().replaceFirst("^\\/", "").replaceAll("/", separator).trim();
        });
        log.info(String.format("Successfully updated header/column values with separator \"%s\"", separator));
    }
}

