/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonparser.writer;

import com.github.jsonparser.exception.JsonParsingException;
import com.github.jsonparser.util.ErrorUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.logging.Logger;

public class CsvWriter {
    public static final Logger log = Logger.getLogger(CsvWriter.class.getName());

    private CsvWriter() {
    }

    public static void write2csv(List<Object[]> records, String destination) throws JsonParsingException {
        CsvWriter.write2csv(records, destination, ",");
    }

    public static String write2String(List<Object[]> records) throws JsonParsingException {
        return CsvWriter.write2String(records, ",");
    }

    public static void write2csv(List<Object[]> records, String destination, String delimiter) throws JsonParsingException {
        log.info(String.format("Writing csv records to file : %s, with delimiter \"%s\"", destination, delimiter));
        try {
            PrintWriter writer = new PrintWriter(new File(destination), Charset.defaultCharset().name());
            CsvWriter.write(records, writer, delimiter);
            writer.close();
        }
        catch (FileNotFoundException e) {
            ErrorUtil.jsonParsingException(String.format("The specified file: %s is not found for processing.", destination), e);
        }
        catch (UnsupportedEncodingException e) {
            ErrorUtil.jsonParsingException("The exception occurred while parsing the file.", e);
        }
        log.info(String.format("The csv records written in file : %s successfully.", destination));
    }

    public static String write2String(List<Object[]> records, String delimiter) throws JsonParsingException {
        StringWriter writer = new StringWriter();
        try {
            CsvWriter.write(records, writer, delimiter);
            writer.close();
        }
        catch (IOException e) {
            ErrorUtil.jsonParsingException("The IO exception occurred while reading a file.", e);
        }
        return writer.toString();
    }

    public static void write(List<Object[]> records, Writer writer) throws JsonParsingException {
        CsvWriter.write(records, writer, ",");
    }

    public static void write(List<Object[]> records, Writer writer, String delimiter) throws JsonParsingException {
        log.info(String.format("Writing records as csv representation with delimiter \"%s\"", delimiter));
        try {
            for (Object[] data : records) {
                boolean comma = false;
                for (Object text : data) {
                    String str = text == null ? (comma ? delimiter : "") : (comma ? delimiter + text.toString() : text.toString());
                    writer.write(str);
                    if (comma) continue;
                    comma = true;
                }
                writer.write("\n");
            }
        }
        catch (IOException e) {
            ErrorUtil.jsonParsingException("The IO exception occurred while reading a file.", e);
        }
        log.info("The records written as csv successfully.");
    }
}

