/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.DistanceComputer;
import com.vectorsearch.faiss.swig.FloatVector;
import com.vectorsearch.faiss.swig.IDSelector;
import com.vectorsearch.faiss.swig.Index;
import com.vectorsearch.faiss.swig.MetricType;
import com.vectorsearch.faiss.swig.RangeSearchResult;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_long;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_unsigned_char;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class IndexFlat
extends Index {
    private transient long swigCPtr;

    protected IndexFlat(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.IndexFlat_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IndexFlat obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_IndexFlat(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setXb(FloatVector value) {
        swigfaissJNI.IndexFlat_xb_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getXb() {
        long cPtr = swigfaissJNI.IndexFlat_xb_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public IndexFlat(int d, MetricType metric) {
        this(swigfaissJNI.new_IndexFlat__SWIG_0(d, metric.swigValue()), true);
    }

    public IndexFlat(int d) {
        this(swigfaissJNI.new_IndexFlat__SWIG_1(d), true);
    }

    @Override
    public void add(int n, SWIGTYPE_p_float x) {
        swigfaissJNI.IndexFlat_add(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public void reset() {
        swigfaissJNI.IndexFlat_reset(this.swigCPtr, this);
    }

    @Override
    public void search(int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
        swigfaissJNI.IndexFlat_search(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
    }

    @Override
    public void range_search(int n, SWIGTYPE_p_float x, float radius, RangeSearchResult result) {
        swigfaissJNI.IndexFlat_range_search(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), radius, RangeSearchResult.getCPtr(result), result);
    }

    @Override
    public void reconstruct(int key, SWIGTYPE_p_float recons) {
        swigfaissJNI.IndexFlat_reconstruct(this.swigCPtr, this, key, SWIGTYPE_p_float.getCPtr(recons));
    }

    public void compute_distance_subset(int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
        swigfaissJNI.IndexFlat_compute_distance_subset(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
    }

    @Override
    public long remove_ids(IDSelector sel) {
        return swigfaissJNI.IndexFlat_remove_ids(this.swigCPtr, this, IDSelector.getCPtr(sel), sel);
    }

    public IndexFlat() {
        this(swigfaissJNI.new_IndexFlat__SWIG_2(), true);
    }

    @Override
    public DistanceComputer get_distance_computer() {
        long cPtr = swigfaissJNI.IndexFlat_get_distance_computer(this.swigCPtr, this);
        return cPtr == 0L ? null : new DistanceComputer(cPtr, false);
    }

    @Override
    public long sa_code_size() {
        return swigfaissJNI.IndexFlat_sa_code_size(this.swigCPtr, this);
    }

    @Override
    public void sa_encode(int n, SWIGTYPE_p_float x, SWIGTYPE_p_unsigned_char bytes) {
        swigfaissJNI.IndexFlat_sa_encode(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_unsigned_char.getCPtr(bytes));
    }

    @Override
    public void sa_decode(int n, SWIGTYPE_p_unsigned_char bytes, SWIGTYPE_p_float x) {
        swigfaissJNI.IndexFlat_sa_decode(this.swigCPtr, this, n, SWIGTYPE_p_unsigned_char.getCPtr(bytes), SWIGTYPE_p_float.getCPtr(x));
    }
}

