/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.HNSW;
import com.vectorsearch.faiss.swig.Index;
import com.vectorsearch.faiss.swig.ReconstructFromNeighbors;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_int;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_long;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class IndexHNSW
extends Index {
    private transient long swigCPtr;

    protected IndexHNSW(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.IndexHNSW_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(IndexHNSW obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_IndexHNSW(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setHnsw(HNSW value) {
        swigfaissJNI.IndexHNSW_hnsw_set(this.swigCPtr, this, HNSW.getCPtr(value), value);
    }

    public HNSW getHnsw() {
        long cPtr = swigfaissJNI.IndexHNSW_hnsw_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new HNSW(cPtr, false);
    }

    public void setOwn_fields(boolean value) {
        swigfaissJNI.IndexHNSW_own_fields_set(this.swigCPtr, this, value);
    }

    public boolean getOwn_fields() {
        return swigfaissJNI.IndexHNSW_own_fields_get(this.swigCPtr, this);
    }

    public void setStorage(Index value) {
        swigfaissJNI.IndexHNSW_storage_set(this.swigCPtr, this, Index.getCPtr(value), value);
    }

    public Index getStorage() {
        long cPtr = swigfaissJNI.IndexHNSW_storage_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new Index(cPtr, false);
    }

    public void setReconstruct_from_neighbors(ReconstructFromNeighbors value) {
        swigfaissJNI.IndexHNSW_reconstruct_from_neighbors_set(this.swigCPtr, this, ReconstructFromNeighbors.getCPtr(value), value);
    }

    public ReconstructFromNeighbors getReconstruct_from_neighbors() {
        long cPtr = swigfaissJNI.IndexHNSW_reconstruct_from_neighbors_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new ReconstructFromNeighbors(cPtr, false);
    }

    public IndexHNSW(int d, int M) {
        this(swigfaissJNI.new_IndexHNSW__SWIG_0(d, M), true);
    }

    public IndexHNSW(int d) {
        this(swigfaissJNI.new_IndexHNSW__SWIG_1(d), true);
    }

    public IndexHNSW() {
        this(swigfaissJNI.new_IndexHNSW__SWIG_2(), true);
    }

    public IndexHNSW(Index storage, int M) {
        this(swigfaissJNI.new_IndexHNSW__SWIG_3(Index.getCPtr(storage), storage, M), true);
    }

    public IndexHNSW(Index storage) {
        this(swigfaissJNI.new_IndexHNSW__SWIG_4(Index.getCPtr(storage), storage), true);
    }

    @Override
    public void add(int n, SWIGTYPE_p_float x) {
        swigfaissJNI.IndexHNSW_add(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public void train(int n, SWIGTYPE_p_float x) {
        swigfaissJNI.IndexHNSW_train(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public void search(int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
        swigfaissJNI.IndexHNSW_search(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
    }

    @Override
    public void reconstruct(int key, SWIGTYPE_p_float recons) {
        swigfaissJNI.IndexHNSW_reconstruct(this.swigCPtr, this, key, SWIGTYPE_p_float.getCPtr(recons));
    }

    @Override
    public void reset() {
        swigfaissJNI.IndexHNSW_reset(this.swigCPtr, this);
    }

    public void shrink_level_0_neighbors(int size) {
        swigfaissJNI.IndexHNSW_shrink_level_0_neighbors(this.swigCPtr, this, size);
    }

    public void search_level_0(int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_int nearest, SWIGTYPE_p_float nearest_d, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels, int nprobe, int search_type) {
        swigfaissJNI.IndexHNSW_search_level_0__SWIG_0(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_int.getCPtr(nearest), SWIGTYPE_p_float.getCPtr(nearest_d), SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels), nprobe, search_type);
    }

    public void search_level_0(int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_int nearest, SWIGTYPE_p_float nearest_d, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels, int nprobe) {
        swigfaissJNI.IndexHNSW_search_level_0__SWIG_1(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_int.getCPtr(nearest), SWIGTYPE_p_float.getCPtr(nearest_d), SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels), nprobe);
    }

    public void search_level_0(int n, SWIGTYPE_p_float x, int k, SWIGTYPE_p_int nearest, SWIGTYPE_p_float nearest_d, SWIGTYPE_p_float distances, SWIGTYPE_p_long labels) {
        swigfaissJNI.IndexHNSW_search_level_0__SWIG_2(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), k, SWIGTYPE_p_int.getCPtr(nearest), SWIGTYPE_p_float.getCPtr(nearest_d), SWIGTYPE_p_float.getCPtr(distances), SWIGTYPE_p_long.getCPtr(labels));
    }

    public void init_level_0_from_knngraph(int k, SWIGTYPE_p_float D, SWIGTYPE_p_long I) {
        swigfaissJNI.IndexHNSW_init_level_0_from_knngraph(this.swigCPtr, this, k, SWIGTYPE_p_float.getCPtr(D), SWIGTYPE_p_long.getCPtr(I));
    }

    public void init_level_0_from_entry_points(int npt, SWIGTYPE_p_int points, SWIGTYPE_p_int nearests) {
        swigfaissJNI.IndexHNSW_init_level_0_from_entry_points(this.swigCPtr, this, npt, SWIGTYPE_p_int.getCPtr(points), SWIGTYPE_p_int.getCPtr(nearests));
    }

    public void reorder_links() {
        swigfaissJNI.IndexHNSW_reorder_links(this.swigCPtr, this);
    }

    public void link_singletons() {
        swigfaissJNI.IndexHNSW_link_singletons(this.swigCPtr, this);
    }
}

