/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.DoubleVector;
import com.vectorsearch.faiss.swig.FloatVector;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.VectorTransform;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class LinearTransform
extends VectorTransform {
    private transient long swigCPtr;

    protected LinearTransform(long cPtr, boolean cMemoryOwn) {
        super(swigfaissJNI.LinearTransform_SWIGUpcast(cPtr), cMemoryOwn);
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(LinearTransform obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_LinearTransform(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public void setHave_bias(boolean value) {
        swigfaissJNI.LinearTransform_have_bias_set(this.swigCPtr, this, value);
    }

    public boolean getHave_bias() {
        return swigfaissJNI.LinearTransform_have_bias_get(this.swigCPtr, this);
    }

    public void setIs_orthonormal(boolean value) {
        swigfaissJNI.LinearTransform_is_orthonormal_set(this.swigCPtr, this, value);
    }

    public boolean getIs_orthonormal() {
        return swigfaissJNI.LinearTransform_is_orthonormal_get(this.swigCPtr, this);
    }

    public void setA(FloatVector value) {
        swigfaissJNI.LinearTransform_A_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getA() {
        long cPtr = swigfaissJNI.LinearTransform_A_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public void setB(FloatVector value) {
        swigfaissJNI.LinearTransform_b_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getB() {
        long cPtr = swigfaissJNI.LinearTransform_b_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public LinearTransform(int d_in, int d_out, boolean have_bias) {
        this(swigfaissJNI.new_LinearTransform__SWIG_0(d_in, d_out, have_bias), true);
    }

    public LinearTransform(int d_in, int d_out) {
        this(swigfaissJNI.new_LinearTransform__SWIG_1(d_in, d_out), true);
    }

    public LinearTransform(int d_in) {
        this(swigfaissJNI.new_LinearTransform__SWIG_2(d_in), true);
    }

    public LinearTransform() {
        this(swigfaissJNI.new_LinearTransform__SWIG_3(), true);
    }

    @Override
    public void apply_noalloc(int n, SWIGTYPE_p_float x, SWIGTYPE_p_float xt) {
        swigfaissJNI.LinearTransform_apply_noalloc(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(xt));
    }

    public void transform_transpose(int n, SWIGTYPE_p_float y, SWIGTYPE_p_float x) {
        swigfaissJNI.LinearTransform_transform_transpose(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(y), SWIGTYPE_p_float.getCPtr(x));
    }

    @Override
    public void reverse_transform(int n, SWIGTYPE_p_float xt, SWIGTYPE_p_float x) {
        swigfaissJNI.LinearTransform_reverse_transform(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(xt), SWIGTYPE_p_float.getCPtr(x));
    }

    public void set_is_orthonormal() {
        swigfaissJNI.LinearTransform_set_is_orthonormal(this.swigCPtr, this);
    }

    public void setVerbose(boolean value) {
        swigfaissJNI.LinearTransform_verbose_set(this.swigCPtr, this, value);
    }

    public boolean getVerbose() {
        return swigfaissJNI.LinearTransform_verbose_get(this.swigCPtr, this);
    }

    public void print_if_verbose(String name, DoubleVector mat, int n, int d) {
        swigfaissJNI.LinearTransform_print_if_verbose(this.swigCPtr, this, name, DoubleVector.getCPtr(mat), mat, n, d);
    }
}

