/*
 * Decompiled with CFR 0.152.
 */
package com.vectorsearch.faiss.swig;

import com.vectorsearch.faiss.swig.FloatVector;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_float;
import com.vectorsearch.faiss.swig.SWIGTYPE_p_int;
import com.vectorsearch.faiss.swig.swigfaissJNI;

public class ZnSphereSearch {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ZnSphereSearch(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ZnSphereSearch obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                swigfaissJNI.delete_ZnSphereSearch(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setDimS(int value) {
        swigfaissJNI.ZnSphereSearch_dimS_set(this.swigCPtr, this, value);
    }

    public int getDimS() {
        return swigfaissJNI.ZnSphereSearch_dimS_get(this.swigCPtr, this);
    }

    public void setR2(int value) {
        swigfaissJNI.ZnSphereSearch_r2_set(this.swigCPtr, this, value);
    }

    public int getR2() {
        return swigfaissJNI.ZnSphereSearch_r2_get(this.swigCPtr, this);
    }

    public void setNatom(int value) {
        swigfaissJNI.ZnSphereSearch_natom_set(this.swigCPtr, this, value);
    }

    public int getNatom() {
        return swigfaissJNI.ZnSphereSearch_natom_get(this.swigCPtr, this);
    }

    public void setVoc(FloatVector value) {
        swigfaissJNI.ZnSphereSearch_voc_set(this.swigCPtr, this, FloatVector.getCPtr(value), value);
    }

    public FloatVector getVoc() {
        long cPtr = swigfaissJNI.ZnSphereSearch_voc_get(this.swigCPtr, this);
        return cPtr == 0L ? null : new FloatVector(cPtr, false);
    }

    public ZnSphereSearch(int dim, int r2) {
        this(swigfaissJNI.new_ZnSphereSearch(dim, r2), true);
    }

    public float search(SWIGTYPE_p_float x, SWIGTYPE_p_float c) {
        return swigfaissJNI.ZnSphereSearch_search__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(c));
    }

    public float search(SWIGTYPE_p_float x, SWIGTYPE_p_float c, SWIGTYPE_p_float tmp, SWIGTYPE_p_int tmp_int, SWIGTYPE_p_int ibest_out) {
        return swigfaissJNI.ZnSphereSearch_search__SWIG_1(this.swigCPtr, this, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(c), SWIGTYPE_p_float.getCPtr(tmp), SWIGTYPE_p_int.getCPtr(tmp_int), SWIGTYPE_p_int.getCPtr(ibest_out));
    }

    public float search(SWIGTYPE_p_float x, SWIGTYPE_p_float c, SWIGTYPE_p_float tmp, SWIGTYPE_p_int tmp_int) {
        return swigfaissJNI.ZnSphereSearch_search__SWIG_2(this.swigCPtr, this, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(c), SWIGTYPE_p_float.getCPtr(tmp), SWIGTYPE_p_int.getCPtr(tmp_int));
    }

    public void search_multi(int n, SWIGTYPE_p_float x, SWIGTYPE_p_float c_out, SWIGTYPE_p_float dp_out) {
        swigfaissJNI.ZnSphereSearch_search_multi(this.swigCPtr, this, n, SWIGTYPE_p_float.getCPtr(x), SWIGTYPE_p_float.getCPtr(c_out), SWIGTYPE_p_float.getCPtr(dp_out));
    }
}

