/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.SoapUIProTestCaseRunner;
import com.eviware.soapui.tools.SoapUITestCaseRunner;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.ktc.soapui.maven.extension.impl.ErrorHandler;
import org.ktc.soapui.maven.extension.impl.ProjectInfo;

public class TestMojo
extends AbstractMojo {
    public static final String TEST_FAILURES_AND_ERRORS_KEY = "soapui_extension_Mlx#ppp";
    private String projectFile;
    private String testSuite;
    private String testCase;
    private String username;
    private String password;
    private String wssPasswordType;
    private String domain;
    private String host;
    private String endpoint;
    private String outputFolder;
    private boolean printReport;
    private boolean interactive;
    private boolean exportAll;
    private boolean junitReport;
    private boolean openReport;
    private String settingsFile;
    private boolean skip;
    private String projectPassword;
    private String settingsPassword;
    private boolean testFailIgnore;
    private boolean coverage;
    private String[] globalProperties;
    private String[] projectProperties;
    private boolean saveAfterRun;
    private String reportFormat;
    private String reportName;
    private Properties soapuiProperties;
    private String environment;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("You are using " + ProjectInfo.getName() + " " + ProjectInfo.getVersion()));
        if (this.skip || System.getProperty("maven.test.skip", "false").equals("true")) {
            this.getLog().info((CharSequence)"SoapUI tests are skipped.");
            return;
        }
        if (this.projectFile == null) {
            throw new MojoExecutionException("soapui-project-file setting is required");
        }
        SoapUIProTestCaseRunner runner = new SoapUIProTestCaseRunner("SoapUI Pro 4.5.0 Maven2 TestCase Runner");
        runner.setProjectFile(this.projectFile);
        if (this.environment != null) {
            runner.setEnvironment(this.environment);
        }
        if (this.endpoint != null) {
            runner.setEndpoint(this.endpoint);
        }
        if (this.testSuite != null) {
            runner.setTestSuite(this.testSuite);
        }
        if (this.testCase != null) {
            runner.setTestCase(this.testCase);
        }
        if (this.username != null) {
            runner.setUsername(this.username);
        }
        if (this.password != null) {
            runner.setPassword(this.password);
        }
        if (this.wssPasswordType != null) {
            runner.setWssPasswordType(this.wssPasswordType);
        }
        if (this.domain != null) {
            runner.setDomain(this.domain);
        }
        if (this.host != null) {
            runner.setHost(this.host);
        }
        if (this.outputFolder != null) {
            runner.setOutputFolder(this.outputFolder);
        }
        runner.setPrintReport(this.printReport);
        runner.setExportAll(this.exportAll);
        runner.setJUnitReport(this.junitReport);
        runner.setEnableUI(this.interactive);
        runner.setOpenReport(this.openReport);
        runner.setIgnoreError(true);
        runner.setSaveAfterRun(this.saveAfterRun);
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.coverage) {
            runner.initCoverageBuilder();
        }
        if (this.globalProperties != null) {
            runner.setGlobalProperties(this.globalProperties);
        }
        if (this.projectProperties != null) {
            runner.setProjectProperties(this.projectProperties);
        }
        if (this.reportName != null) {
            runner.setReportName(this.reportName);
        }
        if (this.reportFormat != null) {
            runner.setReportFormats(this.reportFormat.split(","));
        }
        if (this.soapuiProperties != null && !this.soapuiProperties.isEmpty()) {
            for (Object keyObject : this.soapuiProperties.keySet()) {
                String key = (String)keyObject;
                this.getLog().info((CharSequence)("Setting " + key + " value " + this.soapuiProperties.getProperty(key)));
                System.setProperty(key, this.soapuiProperties.getProperty(key));
            }
        }
        this.validateConfiguration();
        try {
            runner.run();
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoFailureException("SoapUI has errors: " + e.getMessage(), (Throwable)e);
        }
        boolean hasFailures = ErrorHandler.hasFailures((SoapUITestCaseRunner)runner);
        if (hasFailures) {
            if (this.testFailIgnore) {
                this.getLog().warn((CharSequence)"Some tests have failed (see logs and/or check the printReport, if necessary, set the option to true)");
                this.getLog().debug((CharSequence)"Setting project property soapui_extension_Mlx#ppp");
                this.project.getProperties().setProperty(TEST_FAILURES_AND_ERRORS_KEY, "true");
                this.getLog().debug((CharSequence)("Property soapui_extension_Mlx#ppp set to " + this.project.getProperties().getProperty(TEST_FAILURES_AND_ERRORS_KEY)));
            } else {
                throw new MojoFailureException("SoapUI Test(s) failed: see logs and/or check the printReport (if necessary, set the option to true)");
            }
        }
    }

    private void validateConfiguration() {
        this.getLog().info((CharSequence)"Checking logs configuration");
        String soapuiLogRootKey = "soapui.logroot";
        String soapuiLogRootValue = System.getProperty(soapuiLogRootKey);
        this.getLog().debug((CharSequence)("key " + soapuiLogRootKey + " value " + soapuiLogRootValue));
        if (StringUtils.isBlank((String)soapuiLogRootValue)) {
            Build build = this.project.getBuild();
            String defaultLogDirectoryPath = build.getDirectory() + "/soapui/logs/";
            System.setProperty(soapuiLogRootKey, defaultLogDirectoryPath);
            this.getLog().info((CharSequence)("Using default log directory " + System.getProperty(soapuiLogRootKey)));
        }
        this.getLog().info((CharSequence)"Logs configuration done.");
    }
}

