/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.SoapUIProTestCaseRunner;
import com.eviware.soapui.tools.SoapUITestCaseRunner;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ktc.soapui.maven.extension.AbstractSoapuiMojo;
import org.ktc.soapui.maven.extension.impl.ErrorHandler;
import org.ktc.soapui.maven.extension.impl.RunnerType;
import org.ktc.soapui.maven.extension.impl.enums.EnumConverter;

public class TestMojo
extends AbstractSoapuiMojo {
    public static final String TEST_FAILURES_AND_ERRORS_KEY = "soapui_extension_Mlx#ppp";
    private String projectFile;
    private String testSuite;
    private String testCase;
    private String username;
    private String password;
    private String wssPasswordType;
    private String domain;
    private String host;
    private String endpoint;
    private String outputFolder;
    private boolean printReport;
    private boolean interactive;
    private boolean exportAll;
    private boolean junitReport;
    private boolean openReport;
    private String settingsFile;
    private boolean skip;
    private String projectPassword;
    private String settingsPassword;
    private boolean testFailIgnore;
    private boolean coverage;
    private String[] globalProperties;
    private String[] projectProperties;
    private boolean saveAfterRun;
    private String reportFormat;
    private String reportName;
    private Properties soapuiProperties;
    private String environment;
    private String runnerType;

    @Override
    public void performExecute() throws MojoExecutionException, MojoFailureException {
        if (this.skip || System.getProperty("maven.test.skip", "false").equals("true")) {
            this.getLog().info((CharSequence)"SoapUI tests are skipped.");
            return;
        }
        if (this.projectFile == null) {
            throw new MojoExecutionException("soapui-project-file setting is required");
        }
        RunnerType runnerTypeEnum = EnumConverter.toRunnerType(this.runnerType);
        SoapUITestCaseRunner runner = runnerTypeEnum.newTestRunner();
        runner.setProjectFile(this.projectFile);
        if (this.endpoint != null) {
            runner.setEndpoint(this.endpoint);
        }
        if (this.testSuite != null) {
            runner.setTestSuite(this.testSuite);
        }
        if (this.testCase != null) {
            runner.setTestCase(this.testCase);
        }
        if (this.username != null) {
            runner.setUsername(this.username);
        }
        if (this.password != null) {
            runner.setPassword(this.password);
        }
        if (this.wssPasswordType != null) {
            runner.setWssPasswordType(this.wssPasswordType);
        }
        if (this.domain != null) {
            runner.setDomain(this.domain);
        }
        if (this.host != null) {
            runner.setHost(this.host);
        }
        if (this.outputFolder != null) {
            runner.setOutputFolder(this.outputFolder);
        }
        runner.setPrintReport(this.printReport);
        runner.setExportAll(this.exportAll);
        runner.setJUnitReport(this.junitReport);
        runner.setEnableUI(this.interactive);
        runner.setIgnoreError(true);
        runner.setSaveAfterRun(this.saveAfterRun);
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.globalProperties != null) {
            runner.setGlobalProperties(this.globalProperties);
        }
        if (this.projectProperties != null) {
            runner.setProjectProperties(this.projectProperties);
        }
        if (this.soapuiProperties != null && !this.soapuiProperties.isEmpty()) {
            for (Object keyObject : this.soapuiProperties.keySet()) {
                String key = (String)keyObject;
                this.getLog().info((CharSequence)("Setting " + key + " value " + this.soapuiProperties.getProperty(key)));
                System.setProperty(key, this.soapuiProperties.getProperty(key));
            }
        }
        if (runnerTypeEnum.isProRunner()) {
            SoapUIProTestCaseRunner proRunner = (SoapUIProTestCaseRunner)runner;
            if (this.environment != null) {
                proRunner.setEnvironment(this.environment);
            }
            proRunner.setOpenReport(this.openReport);
            if (this.coverage) {
                proRunner.initCoverageBuilder();
            }
            if (this.reportName != null) {
                proRunner.setReportName(this.reportName);
            }
            if (this.reportFormat != null) {
                proRunner.setReportFormats(this.reportFormat.split(","));
            }
        }
        try {
            runner.run();
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoFailureException("SoapUI has errors: " + e.getMessage(), (Throwable)e);
        }
        boolean hasFailures = ErrorHandler.hasFailures(runner);
        if (hasFailures) {
            if (this.testFailIgnore) {
                this.getLog().warn((CharSequence)"Some tests have failed (see logs and/or check the printReport, if necessary, set the option to true)");
                this.getLog().debug((CharSequence)"Setting project property soapui_extension_Mlx#ppp");
                this.project.getProperties().setProperty(TEST_FAILURES_AND_ERRORS_KEY, "true");
                this.getLog().debug((CharSequence)("Property soapui_extension_Mlx#ppp set to " + this.project.getProperties().getProperty(TEST_FAILURES_AND_ERRORS_KEY)));
            } else {
                throw new MojoFailureException("SoapUI Test(s) failed: see logs and/or check the printReport (if necessary, set the option to true)");
            }
        }
    }
}

