/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.SoapUIProMockServiceRunner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ktc.soapui.maven.extension.AbstractSoapuiRunnerMojo;

public class MockServiceMojo
extends AbstractSoapuiRunnerMojo {
    private String mockService;
    private String path;
    private String port;
    private boolean noBlock;

    @Override
    public void performRunnerExecute() throws MojoExecutionException, MojoFailureException {
        SoapUIProMockServiceRunner runner = new SoapUIProMockServiceRunner("SoapUI Pro Maven2 MockService Runner");
        runner.setProjectFile(this.projectFile);
        if (this.mockService != null) {
            runner.setMockService(this.mockService);
        }
        if (this.path != null) {
            runner.setPath(this.path);
        }
        if (this.port != null) {
            runner.setPort(this.port);
        }
        if (this.settingsFile != null) {
            runner.setSettingsFile(this.settingsFile);
        }
        runner.setBlock(!this.noBlock);
        runner.setSaveAfterRun(this.saveAfterRun);
        if (this.projectPassword != null) {
            runner.setProjectPassword(this.projectPassword);
        }
        if (this.settingsPassword != null) {
            runner.setSoapUISettingsPassword(this.settingsPassword);
        }
        if (this.globalProperties != null) {
            runner.setGlobalProperties(this.globalProperties);
        }
        if (this.projectProperties != null) {
            runner.setProjectProperties(this.projectProperties);
        }
        if (this.soapuiProperties != null && !this.soapuiProperties.isEmpty()) {
            for (Object keyObject : this.soapuiProperties.keySet()) {
                String key = (String)keyObject;
                this.getLog().info((CharSequence)("Setting " + key + " value " + this.soapuiProperties.getProperty(key)));
                System.setProperty(key, this.soapuiProperties.getProperty(key));
            }
        }
        try {
            runner.run();
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoFailureException("SoapUI has errors: " + e.getMessage(), (Throwable)e);
        }
    }
}

