/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import org.apache.maven.model.Build;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.ktc.soapui.maven.extension.impl.ProjectInfo;

public abstract class AbstractSoapuiMojo
extends AbstractMojo {
    protected MavenProject project;

    protected abstract void performExecute() throws MojoExecutionException, MojoFailureException;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)("You are using " + ProjectInfo.getName() + " " + ProjectInfo.getFullVersion()));
        this.getLog().info((CharSequence)("SoapUI version: " + ProjectInfo.getSoapuiVersion()));
        this.configureDefaultLogDirectory();
        this.performExecute();
    }

    private void configureDefaultLogDirectory() {
        Build build = this.project.getBuild();
        String defaultLogDirectoryPath = build.getDirectory() + "/soapui/logs/";
        String soapuiLogRootKey = "soapui.logroot";
        System.setProperty(soapuiLogRootKey, defaultLogDirectoryPath);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("Default log directory is set to " + System.getProperty(soapuiLogRootKey)));
        }
    }
}

