/*
 * Decompiled with CFR 0.152.
 */
package org.ktc.soapui.maven.extension;

import com.eviware.soapui.tools.AbstractSoapUIRunner;
import com.eviware.soapui.tools.SoapUITestCaseRunner;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.ktc.soapui.maven.extension.AbstractSoapuiRunnerMojo;
import org.ktc.soapui.maven.extension.impl.ErrorHandler;
import org.ktc.soapui.maven.extension.impl.TestSuiteProperties;
import org.ktc.soapui.maven.extension.impl.runner.SoapUIExtensionTestCaseRunner;
import org.ktc.soapui.maven.extension.impl.runner.SoapUIProExtensionTestCaseRunner;
import org.ktc.soapui.maven.extension.impl.runner.wrapper.SoapUITestCaseRunnerWrapper;

public class TestMojo
extends AbstractSoapuiRunnerMojo {
    public static final String TEST_FAILURES_AND_ERRORS_KEY = "soapui_extension_Mlx#ppp";
    private String testSuite;
    private String testCase;
    private String username;
    private String password;
    private String wssPasswordType;
    private String domain;
    private String host;
    private String endpoint;
    private boolean printReport;
    private boolean interactive;
    private boolean exportAll;
    private boolean junitReport;
    private boolean openReport;
    private boolean testFailIgnore;
    private boolean coverage;
    private String reportFormat;
    private String reportName;
    private String environment;
    private TestSuiteProperties testSuiteProperties;
    private boolean junitHtmlReport = true;

    @Override
    protected void performRunnerExecute() throws MojoExecutionException, MojoFailureException {
        this.configureAndRun(SoapUITestCaseRunnerWrapper.newSoapUITestCaseRunnerWrapper(this.runnerType), this.projectFile);
    }

    protected void configureAndRun(SoapUITestCaseRunnerWrapper runnerWrapper, String currentProjectFile) throws MojoFailureException {
        this.configureTestRunner(runnerWrapper, currentProjectFile);
        SoapUITestCaseRunner runner = (SoapUITestCaseRunner)runnerWrapper.getRunner();
        try {
            runner.run();
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
            throw new MojoFailureException("SoapUI has errors: " + e.getMessage(), (Throwable)e);
        }
        boolean hasFailures = ErrorHandler.hasFailures(runner);
        if (hasFailures) {
            if (this.testFailIgnore) {
                this.getLog().warn((CharSequence)"Some tests have failed (see logs and/or check the printReport, if necessary, set the option to true)");
                this.getLog().debug((CharSequence)"Setting project property soapui_extension_Mlx#ppp");
                this.project.getProperties().setProperty(TEST_FAILURES_AND_ERRORS_KEY, "true");
                this.getLog().debug((CharSequence)("Property soapui_extension_Mlx#ppp set to " + this.project.getProperties().getProperty(TEST_FAILURES_AND_ERRORS_KEY)));
            } else {
                throw new MojoFailureException("SoapUI Test(s) failed: see logs and/or check the printReport (if necessary, set the option to true)");
            }
        }
    }

    private void configureTestRunner(SoapUITestCaseRunnerWrapper runnerWrapper, String currentProjectFile) {
        SoapUITestCaseRunner runner = (SoapUITestCaseRunner)runnerWrapper.getRunner();
        this.configureWithSharedParameters((AbstractSoapUIRunner)runner, currentProjectFile);
        runner.setEndpoint(this.endpoint);
        runner.setTestSuite(this.testSuite);
        runner.setTestCase(this.testCase);
        runner.setUsername(this.username);
        runner.setPassword(this.password);
        runner.setWssPasswordType(this.wssPasswordType);
        runner.setDomain(this.domain);
        runner.setHost(this.host);
        this.configureOuputFolder(runner, currentProjectFile);
        runner.setPrintReport(this.printReport);
        runner.setExportAll(this.exportAll);
        runner.setJUnitReport(this.junitReport);
        runner.setEnableUI(this.interactive);
        runner.setIgnoreError(true);
        runner.setSaveAfterRun(this.saveAfterRun);
        if (runnerWrapper.isProRunner()) {
            SoapUIProExtensionTestCaseRunner proRunner = (SoapUIProExtensionTestCaseRunner)runner;
            proRunner.setEnvironment(this.environment);
            proRunner.setJunitHtmlReport(this.junitHtmlReport);
            proRunner.setOpenReport(this.openReport);
            if (this.coverage) {
                proRunner.initCoverageBuilder();
            }
            proRunner.setReportName(this.reportName);
            if (this.reportFormat != null) {
                proRunner.setReportFormats(this.reportFormat.split(","));
            }
            proRunner.setTestSuiteProperties(this.testSuiteProperties.getProperties());
        } else {
            SoapUIExtensionTestCaseRunner ossRunner = (SoapUIExtensionTestCaseRunner)runner;
            ossRunner.setTestSuiteProperties(this.testSuiteProperties.getProperties());
        }
    }

    protected void configureOuputFolder(SoapUITestCaseRunner runner, String currentProjectFile) {
        runner.setOutputFolder(this.outputFolder);
    }
}

