/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.reinert.jjschema.Attributes;
import com.github.reinert.jjschema.Nullable;
import com.github.reinert.jjschema.SimpleTypeMappings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class JsonSchemaGenerator {
    final ObjectMapper mapper = new ObjectMapper();
    boolean autoPutVersion = true;

    protected JsonSchemaGenerator() {
    }

    protected abstract void processSchemaProperty(ObjectNode var1, Attributes var2);

    protected ObjectNode createInstance() {
        return this.mapper.createObjectNode();
    }

    public boolean isAutoPutVersion() {
        return this.autoPutVersion;
    }

    public JsonSchemaGenerator setAutoPutVersion(boolean autoPutVersion) {
        this.autoPutVersion = autoPutVersion;
        return this;
    }

    public <T> ObjectNode generateSchema(Class<T> type) {
        ObjectNode schema = this.createInstance();
        schema = this.checkAndProcessType(type, schema);
        return schema;
    }

    protected <T> ObjectNode checkAndProcessType(Class<T> type, ObjectNode schema) {
        String s = SimpleTypeMappings.forClass(type);
        if (s != null) {
            schema.put("type", s);
        } else if (Iterable.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type)) {
            this.checkAndProcessCollection(type, schema);
        } else if (type == Void.class || type == Void.TYPE) {
            schema = null;
        } else if (type.isEnum()) {
            this.processEnum(type, schema);
        } else {
            schema = this.processCustomType(type, schema);
        }
        return schema;
    }

    protected <T> ObjectNode processCustomType(Class<T> type, ObjectNode schema) {
        schema.put("type", "object");
        this.processRootAttributes(type, schema);
        this.processProperties(type, schema);
        schema = this.mergeWithParent(type, schema);
        return schema;
    }

    private <T> void checkAndProcessCollection(Class<T> type, ObjectNode schema) {
        if (AbstractCollection.class.isAssignableFrom(type)) {
            schema.put("type", "array");
        } else {
            this.processRootAttributes(type, schema);
            this.processCustomCollection(type, schema);
        }
    }

    private <T> void processCustomCollection(Class<T> type, ObjectNode schema) {
        schema.put("type", "array");
        Field field = type.getDeclaredFields()[0];
        ParameterizedType genericType = (ParameterizedType)field.getGenericType();
        Class genericClass = (Class)genericType.getActualTypeArguments()[0];
        ObjectNode itemsSchema = this.generateSchema(genericClass);
        itemsSchema.remove("$schema");
        schema.put("items", (JsonNode)itemsSchema);
    }

    private <T> void processEnum(Class<T> type, ObjectNode schema) {
        ArrayNode enumArray = schema.putArray("enum");
        for (T constant : type.getEnumConstants()) {
            String value = constant.toString();
            try {
                Long integer = Long.parseLong(value);
                enumArray.add(integer);
            }
            catch (NumberFormatException e) {
                try {
                    BigDecimal number = new BigDecimal(value);
                    enumArray.add(number);
                }
                catch (NumberFormatException e1) {
                    enumArray.add(value);
                }
            }
        }
    }

    private void processPropertyCollection(Method method, ObjectNode schema) {
        schema.put("type", "array");
        ParameterizedType genericType = (ParameterizedType)method.getGenericReturnType();
        Class genericClass = (Class)genericType.getActualTypeArguments()[0];
        schema.put("items", (JsonNode)this.generateSchema(genericClass));
    }

    protected ObjectNode generatePropertySchema(Method method, Field field) {
        Nullable nullable;
        Attributes attrs;
        ObjectNode schema = this.createInstance();
        if (Collection.class.isAssignableFrom(method.getReturnType())) {
            this.processPropertyCollection(method, schema);
        } else {
            schema = this.generateSchema(method.getReturnType());
        }
        Attributes attributes = attrs = field != null ? field.getAnnotation(Attributes.class) : method.getAnnotation(Attributes.class);
        if (attrs != null) {
            this.processSchemaProperty(schema, attrs);
            schema.remove("$schema");
        }
        Nullable nullable2 = nullable = field != null ? field.getAnnotation(Nullable.class) : method.getAnnotation(Nullable.class);
        if (nullable != null) {
            if (method.getReturnType().isEnum()) {
                ((ArrayNode)schema.get("enum")).add("null");
            } else {
                String oldType = schema.get("type").asText();
                ArrayNode typeArray = schema.putArray("type");
                typeArray.add(oldType);
                typeArray.add("null");
            }
        }
        return schema;
    }

    protected <T> void processRootAttributes(Class<T> type, ObjectNode schema) {
        Attributes sProp = type.getAnnotation(Attributes.class);
        if (sProp != null) {
            this.processSchemaProperty(schema, sProp);
        }
    }

    protected <T> void processProperties(Class<T> type, ObjectNode schema) {
        HashMap<Method, Field> props = this.findProperties(type);
        for (Map.Entry<Method, Field> entry : props.entrySet()) {
            Field field = entry.getValue();
            Method method = entry.getKey();
            ObjectNode prop = this.generatePropertySchema(method, field);
            this.addPropertyToSchema(schema, field, method, prop);
        }
    }

    private void addPropertyToSchema(ObjectNode schema, Field field, Method method, ObjectNode prop) {
        String name = this.getPropertyName(field, method);
        if (prop.has("selfRequired")) {
            ArrayNode requiredNode = null;
            requiredNode = !schema.has("required") ? schema.putArray("required") : (ArrayNode)schema.get("required");
            requiredNode.add(name);
            prop.remove("selfRequired");
        }
        if (!schema.has("properties")) {
            schema.putObject("properties");
        }
        ((ObjectNode)schema.get("properties")).put(name, (JsonNode)prop);
    }

    private String getPropertyName(Field field, Method method) {
        String name = field == null ? this.firstToLowCase(method.getName().replace("get", "")) : field.getName();
        return name;
    }

    protected <T> ObjectNode mergeWithParent(Class<T> type, ObjectNode schema) {
        Class<T> superclass = type.getSuperclass();
        if (superclass != Object.class) {
            ObjectNode parentSchema = this.generateSchema(superclass);
            schema = this.mergeSchema(parentSchema, schema, false);
        }
        return schema;
    }

    protected ObjectNode mergeSchema(ObjectNode parent, ObjectNode child, boolean overwriteChildProperties) {
        block6: {
            Iterator namesIterator;
            block5: {
                namesIterator = child.fieldNames();
                if (!overwriteChildProperties) break block5;
                while (namesIterator.hasNext()) {
                    String propertyName = (String)namesIterator.next();
                    this.overwriteProperty(parent, child, propertyName);
                }
                break block6;
            }
            while (namesIterator.hasNext()) {
                String propertyName = (String)namesIterator.next();
                if (propertyName.equals("properties")) continue;
                this.overwriteProperty(parent, child, propertyName);
            }
            ObjectNode properties = (ObjectNode)child.get("properties");
            if (properties == null) break block6;
            if (parent.get("properties") == null) {
                parent.putObject("properties");
            }
            Iterator it = properties.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String pName = (String)entry.getKey();
                ObjectNode pSchema = (ObjectNode)entry.getValue();
                ObjectNode actualSchema = (ObjectNode)parent.get("properties").get(pName);
                if (actualSchema != null) {
                    this.mergeSchema(pSchema, actualSchema, false);
                }
                ((ObjectNode)parent.get("properties")).put(pName, (JsonNode)pSchema);
            }
        }
        return parent;
    }

    protected void overwriteProperty(ObjectNode parent, ObjectNode child, String propertyName) {
        if (child.has(propertyName)) {
            parent.put(propertyName, child.get(propertyName));
        }
    }

    private <T> HashMap<Method, Field> findProperties(Class<T> type) {
        Field[] fields = type.getDeclaredFields();
        Method[] methods = type.getMethods();
        HashMap<Method, Field> props = new HashMap<Method, Field>();
        for (Method method : methods) {
            String methodName;
            Class<?> declaringClass = method.getDeclaringClass();
            if (declaringClass.equals(Object.class) || Collection.class.isAssignableFrom(declaringClass) || !(methodName = method.getName()).startsWith("get")) continue;
            boolean hasField = false;
            for (Field field : fields) {
                String name = methodName.substring(3);
                if (!field.getName().equalsIgnoreCase(name)) continue;
                props.put(method, field);
                hasField = true;
                break;
            }
            if (hasField) continue;
            props.put(method, null);
        }
        return props;
    }

    private String firstToLowCase(String string) {
        return Character.toLowerCase(string.charAt(0)) + (string.length() > 1 ? string.substring(1) : "");
    }
}

