/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonschema.SchemaVersion;
import com.github.reinert.jjschema.Attributes;
import com.github.reinert.jjschema.JsonSchemaGenerator;

public class JsonSchemaGeneratorV4
extends JsonSchemaGenerator {
    @Override
    protected void processSchemaProperty(ObjectNode schema, Attributes props) {
        if (!props.$ref().isEmpty()) {
            schema.put("$ref", props.$ref());
        }
        if (this.autoPutVersion) {
            schema.put("$schema", SchemaVersion.DRAFTV4.getLocation().toString());
        }
        if (!props.id().isEmpty()) {
            schema.put("id", props.id());
        }
        if (props.required()) {
            schema.put("selfRequired", true);
        }
        if (!props.description().isEmpty()) {
            schema.put("description", props.description());
        }
        if (!props.pattern().isEmpty()) {
            schema.put("pattern", props.pattern());
        }
        if (!props.title().isEmpty()) {
            schema.put("title", props.title());
        }
        if (props.maximum() > -1L) {
            schema.put("maximum", props.maximum());
        }
        if (props.exclusiveMaximum()) {
            schema.put("exclusiveMaximum", true);
        }
        if (props.minimum() > -1) {
            schema.put("minimum", props.minimum());
        }
        if (props.exclusiveMinimum()) {
            schema.put("exclusiveMinimum", true);
        }
        if (props.enums().length > 0) {
            String[] enums;
            ArrayNode enumArray = schema.putArray("enum");
            for (String v : enums = props.enums()) {
                enumArray.add(v);
            }
        }
        if (props.uniqueItems()) {
            schema.put("uniqueItems", true);
        }
        if (props.minItems() > 0) {
            schema.put("minItems", props.minItems());
        }
        if (props.maxItems() > -1L) {
            schema.put("maxItems", props.maxItems());
        }
        if (props.multipleOf() > 0) {
            schema.put("multipleOf", props.multipleOf());
        }
        if (props.minLength() > 0) {
            schema.put("minLength", props.minItems());
        }
        if (props.maxLength() > -1L) {
            schema.put("maxLength", props.maxItems());
        }
    }
}

