/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.IdentityHashMap;
import java.util.Map;

public enum SimpleTypeMappings {
    PRIMITIVE_BYTE(Byte.TYPE, "integer"),
    PRIMITIVE_SHORT(Short.TYPE, "integer"),
    PRIMITIVE_INTEGER(Integer.TYPE, "integer"),
    PRIMITIVE_LONG(Long.TYPE, "integer"),
    BYTE(Byte.class, "integer"),
    SHORT(Short.class, "integer"),
    INTEGER(Integer.class, "integer"),
    LONG(Long.class, "integer"),
    BIGINTEGER(BigInteger.class, "integer"),
    PRIMITIVE_FLOAT(Float.TYPE, "number"),
    PRIMITIVE_DOUBLE(Double.TYPE, "number"),
    FLOAT(Float.class, "number"),
    DOUBLE(Double.class, "number"),
    BIGDECIMAL(BigDecimal.class, "number"),
    PRIMITIVE_BOOLEAN(Boolean.TYPE, "boolean"),
    BOOLEAN(Boolean.class, "boolean"),
    PRIMITIVE_CHAR(Character.TYPE, "string"),
    CHAR(Character.class, "string"),
    CHARSEQUENCE(CharSequence.class, "string"),
    STRING(String.class, "string");

    private static final Map<Class<?>, String> MAPPINGS;
    private final Class<?> c;
    private final String schemaType;

    private SimpleTypeMappings(Class<?> c, String schemaType) {
        this.c = c;
        this.schemaType = schemaType;
    }

    public static String forClass(Class<?> c) {
        return MAPPINGS.get(c);
    }

    static {
        MAPPINGS = new IdentityHashMap();
        for (SimpleTypeMappings mapping : SimpleTypeMappings.values()) {
            MAPPINGS.put(mapping.c, mapping.schemaType);
        }
    }
}

