/*
 * Decompiled with CFR 0.152.
 */
package com.github.reinert.jjschema.v1;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.reinert.jjschema.ManagedReference;
import com.github.reinert.jjschema.v1.RefSchemaWrapper;
import com.github.reinert.jjschema.v1.SchemaWrapper;
import com.github.reinert.jjschema.v1.SchemaWrapperFactory;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;

public class ArraySchemaWrapper
extends SchemaWrapper {
    final SchemaWrapper itemsSchemaWrapper;

    public ArraySchemaWrapper(Class<?> type, Type propertyType, Set<ManagedReference> managedReferences, String relativeId, boolean ignoreProperties) {
        super(type);
        this.setType("array");
        if (propertyType != null) {
            if (!Collection.class.isAssignableFrom(type)) {
                throw new RuntimeException("Cannot instantiate a SchemaWrapper of a non Collection class with a Parametrized Type.");
            }
            this.itemsSchemaWrapper = managedReferences == null ? SchemaWrapperFactory.createWrapper(propertyType) : SchemaWrapperFactory.createWrapper(propertyType, managedReferences, relativeId, ignoreProperties);
            this.setItems(this.itemsSchemaWrapper.asJson());
        } else {
            this.itemsSchemaWrapper = null;
        }
    }

    public ArraySchemaWrapper(Class<?> type, Class<?> parametrizedType, Set<ManagedReference> managedReferences, boolean ignoreProperties) {
        this(type, parametrizedType, managedReferences, null, ignoreProperties);
    }

    public ArraySchemaWrapper(Class<?> type, Class<?> parametrizedType, boolean ignoreProperties) {
        this(type, parametrizedType, null, ignoreProperties);
    }

    public ArraySchemaWrapper(Class<?> type, RefSchemaWrapper refSchemaWrapper) {
        super(type);
        this.setType("array");
        this.itemsSchemaWrapper = refSchemaWrapper;
        this.setItems(this.itemsSchemaWrapper.asJson());
    }

    public Class<?> getJavaParametrizedType() {
        return this.itemsSchemaWrapper.getJavaType();
    }

    public SchemaWrapper getItemsSchema() {
        return this.itemsSchemaWrapper;
    }

    @Override
    public boolean isArrayWrapper() {
        return true;
    }

    protected JsonNode getItems() {
        return this.getNode().get("items");
    }

    protected void setItems(JsonNode itemsNode) {
        this.getNode().put("items", itemsNode);
    }
}

