/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import com.github.restdriver.clientdriver.exception.ClientDriverSetupException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.io.IOException;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Server;

public final class ClientDriver {
    private final Server jettyServer;
    private final int portNum;
    private final ClientDriverJettyHandler handler;

    public ClientDriver(ClientDriverJettyHandler handler) {
        this.handler = handler;
        try {
            this.portNum = this.getFreePort();
        }
        catch (IOException ioe) {
            throw new ClientDriverSetupException("Error finding free port for webserver", ioe);
        }
        this.jettyServer = new Server(this.portNum);
        try {
            this.jettyServer.setHandler(handler.getJettyHandler());
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new ClientDriverSetupException("Error starting jetty", e);
        }
    }

    public String getBaseUrl() {
        return "http://localhost:" + this.portNum;
    }

    private int getFreePort() throws IOException {
        ServerSocket server = new ServerSocket(0);
        int port = server.getLocalPort();
        server.close();
        return port;
    }

    public void shutdown() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            throw new ClientDriverFailedExpectationException("Error shutting down jetty", e);
        }
        this.verify();
    }

    public void addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        this.handler.addExpectation(request, response);
    }

    private void verify() {
        this.handler.checkForUnexpectedRequests();
        this.handler.checkForUnmatchedExpectations();
    }
}

