/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.RequestMatcher;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public final class DefaultRequestMatcher
implements RequestMatcher {
    @Override
    public boolean isMatch(HttpServletRequest actualRequest, ClientDriverRequest expectedRequest) {
        if (!actualRequest.getMethod().equals(expectedRequest.getMethod().toString())) {
            return false;
        }
        if (!this.isStringOrPattternMatch(actualRequest.getPathInfo(), expectedRequest.getPath())) {
            return false;
        }
        if (actualRequest.getParameterMap().size() != expectedRequest.getParams().size()) {
            return false;
        }
        Map<String, Object> expectedParams = expectedRequest.getParams();
        for (String expectedKey : expectedParams.keySet()) {
            String actualParamValue = actualRequest.getParameter(expectedKey);
            if (actualParamValue == null) {
                return false;
            }
            Object expectedParamValue = expectedParams.get(expectedKey);
            if (this.isStringOrPattternMatch(actualParamValue, expectedParamValue)) continue;
            return false;
        }
        if (expectedRequest.getBodyContent() != null) {
            String actualContentType = actualRequest.getContentType();
            if (actualContentType.contains(";")) {
                actualContentType = actualContentType.substring(0, actualContentType.indexOf(59));
            }
            if (!this.isStringOrPattternMatch(actualContentType, expectedRequest.getBodyContentType())) {
                return false;
            }
            try {
                if (!this.isStringOrPattternMatch(IOUtils.toString((Reader)actualRequest.getReader()), expectedRequest.getBodyContent())) {
                    return false;
                }
            }
            catch (IOException ioException) {
                throw new ClientDriverInternalException("Internal error, IOException while reading from body content", ioException);
            }
        }
        return true;
    }

    private boolean isStringOrPattternMatch(String actual, Object expected) {
        if (expected instanceof String) {
            return actual.equals(expected);
        }
        if (expected instanceof Pattern) {
            Pattern pattern = (Pattern)expected;
            return pattern.matcher(actual).matches();
        }
        throw new ClientDriverInternalException("DefaultRequestMatcher asked to match " + expected.getClass() + ", but only knows String and Pattern.", null);
    }
}

