/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver.jetty;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverRequestResponsePair;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.RequestMatcher;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public final class DefaultClientDriverJettyHandler
extends AbstractHandler
implements ClientDriverJettyHandler {
    private final List<ClientDriverRequestResponsePair> expectedResponses = new ArrayList<ClientDriverRequestResponsePair>();
    private final List<ClientDriverRequestResponsePair> matchedResponses = new ArrayList<ClientDriverRequestResponsePair>();
    private final RequestMatcher matcher;
    private String unexpectedRequest;

    public DefaultClientDriverJettyHandler(RequestMatcher matcher) {
        this.matcher = matcher;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ClientDriverRequestResponsePair matchingPair = this.getMatchingRequestPair(request);
        this.matchedResponses.add(matchingPair);
        ClientDriverResponse matchedResponse = matchingPair.getResponse();
        response.setContentType(matchedResponse.getContentType());
        response.setStatus(matchedResponse.getStatus());
        response.getWriter().print(matchedResponse.getContent());
        for (Map.Entry<String, String> thisHeader : matchedResponse.getHeaders().entrySet()) {
            response.setHeader(thisHeader.getKey(), thisHeader.getValue());
        }
        baseRequest.setHandled(true);
    }

    private ClientDriverRequestResponsePair getMatchingRequestPair(HttpServletRequest request) {
        int index = 0;
        ClientDriverRequestResponsePair matchedPair = null;
        for (index = 0; index < this.expectedResponses.size(); ++index) {
            ClientDriverRequestResponsePair thisPair = this.expectedResponses.get(index);
            if (!this.matcher.isMatch(request, thisPair.getRequest()) || matchedPair != null) continue;
            matchedPair = thisPair;
            break;
        }
        if (matchedPair == null) {
            this.unexpectedRequest = request.getPathInfo();
            String reqQuery = request.getQueryString();
            if (reqQuery != null) {
                this.unexpectedRequest = this.unexpectedRequest + "?" + reqQuery;
            }
            throw new ClientDriverInternalException("Unexpected request: " + this.unexpectedRequest, null);
        }
        this.expectedResponses.remove(index);
        return matchedPair;
    }

    @Override
    public void checkForUnexpectedRequests() {
        if (this.unexpectedRequest != null) {
            throw new ClientDriverFailedExpectationException("Unexpected request: " + this.unexpectedRequest, null);
        }
    }

    @Override
    public void checkForUnmatchedExpectations() {
        if (!this.expectedResponses.isEmpty()) {
            throw new ClientDriverFailedExpectationException(this.expectedResponses.size() + " unmatched expectation(s), first is: " + this.expectedResponses.get(0).getRequest(), null);
        }
    }

    @Override
    public void addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        this.expectedResponses.add(new ClientDriverRequestResponsePair(request, response));
    }

    @Override
    public Handler getJettyHandler() {
        return this;
    }
}

