/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriver;
import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverFactory;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public final class ClientDriverRule
implements MethodRule {
    private final ClientDriver clientDriver;

    public ClientDriverRule() {
        this.clientDriver = new ClientDriverFactory().createClientDriver();
    }

    public ClientDriverRule(int port) {
        this.clientDriver = new ClientDriverFactory().createClientDriver(port);
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        return new ClientDriverStatement(base);
    }

    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        return this.clientDriver.addExpectation(request, response);
    }

    public String getBaseUrl() {
        return this.clientDriver.getBaseUrl();
    }

    private class ClientDriverStatement
    extends Statement {
        private final Statement statement;

        public ClientDriverStatement(Statement statement) {
            this.statement = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            try {
                this.statement.evaluate();
                ClientDriverRule.this.clientDriver.verify();
            }
            finally {
                ClientDriverRule.this.clientDriver.shutdownQuietly();
            }
        }
    }
}

