/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.RequestMatcher;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public final class DefaultRequestMatcher
implements RequestMatcher {
    @Override
    public boolean isMatch(HttpServletRequest actualRequest, ClientDriverRequest expectedRequest) {
        if (!actualRequest.getMethod().equals(expectedRequest.getMethod().toString())) {
            return false;
        }
        if (!this.isStringOrPatternMatch(actualRequest.getPathInfo(), expectedRequest.getPath())) {
            return false;
        }
        Map actualParams = actualRequest.getParameterMap();
        if (actualParams.size() != expectedRequest.getParams().size()) {
            return false;
        }
        Map<String, Collection<Object>> expectedParams = expectedRequest.getParams();
        for (String expectedKey : expectedParams.keySet()) {
            String[] actualParamValues = (String[])actualParams.get(expectedKey);
            if (actualParamValues == null || actualParamValues.length == 0) {
                return false;
            }
            Collection<Object> expectedParamValues = expectedParams.get(expectedKey);
            if (expectedParamValues.size() != actualParamValues.length) {
                return false;
            }
            for (String actualParamValue : actualParamValues) {
                boolean matched = false;
                for (Object expectedParamValue : expectedParamValues) {
                    if (!this.isStringOrPatternMatch(actualParamValue, expectedParamValue)) continue;
                    matched = true;
                }
                if (matched) continue;
                return false;
            }
        }
        Map<String, Object> expectedHeaders = expectedRequest.getHeaders();
        for (String expectedHeaderName : expectedHeaders.keySet()) {
            Enumeration actualHeaderValues = actualRequest.getHeaders(expectedHeaderName);
            if (actualHeaderValues == null) {
                return false;
            }
            Object expectedHeaderValue = expectedHeaders.get(expectedHeaderName);
            boolean matched = false;
            while (actualHeaderValues.hasMoreElements()) {
                String value = (String)actualHeaderValues.nextElement();
                if (!this.isStringOrPatternMatch(value, expectedHeaderValue)) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        if (expectedRequest.getBodyContent() != null) {
            String actualContentType = actualRequest.getContentType();
            if (actualContentType.contains(";")) {
                actualContentType = actualContentType.substring(0, actualContentType.indexOf(59));
            }
            if (!this.isStringOrPatternMatch(actualContentType, expectedRequest.getBodyContentType())) {
                return false;
            }
            try {
                if (!this.isStringOrPatternMatch(IOUtils.toString((Reader)actualRequest.getReader()), expectedRequest.getBodyContent())) {
                    return false;
                }
            }
            catch (IOException ioException) {
                throw new ClientDriverInternalException("Internal error, IOException while reading from body content", ioException);
            }
        }
        return true;
    }

    private boolean isStringOrPatternMatch(String actual, Object expected) {
        if (expected instanceof String) {
            return actual.equals(expected);
        }
        if (expected instanceof Pattern) {
            Pattern pattern = (Pattern)expected;
            return pattern.matcher(actual).matches();
        }
        throw new ClientDriverInternalException("DefaultRequestMatcher asked to match " + expected.getClass() + ", but only knows String and Pattern.", null);
    }
}

