/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver.jetty;

import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverRequestResponsePair;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.RequestMatcher;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import com.github.restdriver.clientdriver.exception.ClientDriverInternalException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public final class DefaultClientDriverJettyHandler
extends AbstractHandler
implements ClientDriverJettyHandler {
    private final List<ClientDriverExpectation> expectations = new ArrayList<ClientDriverExpectation>();
    private final List<ClientDriverRequestResponsePair> matchedResponses = new ArrayList<ClientDriverRequestResponsePair>();
    private final RequestMatcher matcher;
    private String unexpectedRequest;

    public DefaultClientDriverJettyHandler(RequestMatcher matcher) {
        this.matcher = matcher;
    }

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ClientDriverRequestResponsePair matchingPair = this.getMatchingRequestPair(request);
        this.matchedResponses.add(matchingPair);
        ClientDriverResponse matchedResponse = matchingPair.getResponse();
        response.setContentType(matchedResponse.getContentType());
        response.setStatus(matchedResponse.getStatus());
        response.getWriter().print(matchedResponse.getContent());
        for (Map.Entry<String, String> thisHeader : matchedResponse.getHeaders().entrySet()) {
            response.setHeader(thisHeader.getKey(), thisHeader.getValue());
        }
        this.delayIfNecessary(matchingPair.getResponse());
        baseRequest.setHandled(true);
    }

    private void delayIfNecessary(ClientDriverResponse response) {
        if (response.getDelayTime() > 0L) {
            try {
                response.getDelayTimeUnit().sleep(response.getDelayTime());
            }
            catch (InterruptedException ie) {
                throw new ClientDriverInternalException("Requested delay was interrupted", ie);
            }
        }
    }

    private ClientDriverRequestResponsePair getMatchingRequestPair(HttpServletRequest request) {
        int index = 0;
        ClientDriverExpectation matchedExpectation = null;
        for (index = 0; index < this.expectations.size(); ++index) {
            ClientDriverExpectation thisExpectation = this.expectations.get(index);
            ClientDriverRequestResponsePair thisPair = thisExpectation.getPair();
            if (!this.matcher.isMatch(request, thisPair.getRequest())) continue;
            thisExpectation.match();
            if (matchedExpectation != null) continue;
            matchedExpectation = thisExpectation;
            break;
        }
        if (matchedExpectation == null) {
            this.unexpectedRequest = request.getPathInfo();
            String reqQuery = request.getQueryString();
            if (reqQuery != null) {
                this.unexpectedRequest = this.unexpectedRequest + "?" + reqQuery;
            }
            throw new ClientDriverInternalException("Unexpected request: " + this.unexpectedRequest, null);
        }
        if (matchedExpectation.isSatisfied()) {
            this.expectations.remove(index);
        }
        return matchedExpectation.getPair();
    }

    @Override
    public void checkForUnexpectedRequests() {
        if (this.unexpectedRequest != null) {
            throw new ClientDriverFailedExpectationException("Unexpected request: " + this.unexpectedRequest, null);
        }
    }

    @Override
    public void checkForUnmatchedExpectations() {
        if (this.expectations.isEmpty()) {
            return;
        }
        for (ClientDriverExpectation expectation : this.expectations) {
            if (expectation.shouldMatchAnyTimes()) continue;
            throw new ClientDriverFailedExpectationException(this.expectations.size() + " unmatched expectation(s), first is: " + expectation.getPair().getRequest() + expectation.getStatusString(), null);
        }
    }

    @Override
    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        ClientDriverRequestResponsePair pair = new ClientDriverRequestResponsePair(request, response);
        ClientDriverExpectation expectation = new ClientDriverExpectation(pair);
        this.expectations.add(expectation);
        return expectation;
    }

    @Override
    public Handler getJettyHandler() {
        return this;
    }
}

