/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequestResponsePair;
import com.github.restdriver.clientdriver.exception.ClientDriverInvalidExpectationException;

public class ClientDriverExpectation {
    private final ClientDriverRequestResponsePair pair;
    private int numberOfTimes = 1;
    private int numberOfMatches;
    private boolean matchAnyTimes;

    public ClientDriverExpectation(ClientDriverRequestResponsePair pair) {
        this.pair = pair;
    }

    public final ClientDriverRequestResponsePair getPair() {
        return this.pair;
    }

    public final void times(int times) {
        if (times < 1) {
            throw new ClientDriverInvalidExpectationException("Expectation cannot be matched less than once");
        }
        this.numberOfTimes = times;
    }

    public final void anyTimes() {
        this.matchAnyTimes = true;
    }

    public final void match() {
        ++this.numberOfMatches;
    }

    public final boolean isSatisfied() {
        return !this.matchAnyTimes && this.numberOfTimes == this.numberOfMatches;
    }

    public final boolean shouldMatchAnyTimes() {
        return this.matchAnyTimes;
    }

    public final String getStatusString() {
        String expectedString = this.matchAnyTimes ? "any" : String.valueOf(this.numberOfTimes);
        return "expected: " + expectedString + ", actual: " + this.numberOfMatches;
    }
}

