/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public final class ClientDriverResponse {
    private static final int DEFAULT_STATUS_CODE = 200;
    private static final int EMPTY_RESPONSE_CODE = 204;
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String DEFAULT_CONTENT_TYPE = "text/plain";
    private int status;
    private final String content;
    private String contentType;
    private final Map<String, String> headers;
    private long delayTime;
    private TimeUnit delayTimeUnit = TimeUnit.SECONDS;

    public ClientDriverResponse() {
        this(null);
    }

    public ClientDriverResponse(String content) {
        this.content = content;
        this.status = ClientDriverResponse.statusCodeForContent(content);
        this.contentType = DEFAULT_CONTENT_TYPE;
        this.headers = new HashMap<String, String>();
    }

    private static int statusCodeForContent(String content) {
        if (content == null) {
            return 204;
        }
        return 200;
    }

    public String getContent() {
        if (this.content == null) {
            return "";
        }
        return this.content;
    }

    public ClientDriverResponse withStatus(int withStatus) {
        this.status = withStatus;
        return this;
    }

    public ClientDriverResponse after(long delay, TimeUnit timeUnit) {
        this.delayTime = delay;
        this.delayTimeUnit = timeUnit;
        return this;
    }

    public long getDelayTime() {
        return this.delayTime;
    }

    public TimeUnit getDelayTimeUnit() {
        return this.delayTimeUnit;
    }

    public int getStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ClientDriverResponse withContentType(String withContentType) {
        this.contentType = withContentType;
        return this;
    }

    public ClientDriverResponse withHeader(String name, String value) {
        if (CONTENT_TYPE.equalsIgnoreCase(name)) {
            this.contentType = value;
        } else {
            this.headers.put(name, value);
        }
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

