/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriver;
import com.github.restdriver.clientdriver.ClientDriverExpectation;
import com.github.restdriver.clientdriver.ClientDriverFactory;
import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientDriverRule
implements TestRule {
    private final ClientDriver clientDriver;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientDriverRequest.class);

    public ClientDriverRule() {
        this.clientDriver = new ClientDriverFactory().createClientDriver();
    }

    public ClientDriverRule(int port) {
        this.clientDriver = new ClientDriverFactory().createClientDriver(port);
    }

    public Statement apply(Statement base, Description description) {
        return new ClientDriverStatement(base);
    }

    public ClientDriverExpectation addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        LOGGER.info("addExpectation: " + request.getPath());
        return this.clientDriver.addExpectation(request, response);
    }

    public String getBaseUrl() {
        return this.clientDriver.getBaseUrl();
    }

    private class ClientDriverStatement
    extends Statement {
        private final Statement statement;

        public ClientDriverStatement(Statement statement) {
            this.statement = statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() throws Throwable {
            AssertionError assertionError = null;
            try {
                this.statement.evaluate();
            }
            catch (AssertionError e) {
                assertionError = e;
            }
            try {
                ClientDriverRule.this.clientDriver.verify();
                if (assertionError != null) {
                    throw assertionError;
                }
            }
            finally {
                ClientDriverRule.this.clientDriver.shutdownQuietly();
            }
        }
    }
}

