/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import com.github.restdriver.clientdriver.ClientDriverRequest;
import com.github.restdriver.clientdriver.ClientDriverResponse;
import com.github.restdriver.clientdriver.exception.ClientDriverFailedExpectationException;
import com.github.restdriver.clientdriver.exception.ClientDriverSetupException;
import com.github.restdriver.clientdriver.jetty.ClientDriverJettyHandler;
import java.io.IOException;
import java.net.ServerSocket;
import org.eclipse.jetty.server.Server;

public final class ClientDriver {
    private final Server jettyServer;
    private final int portNum;
    private final ClientDriverJettyHandler handler;

    public ClientDriver(ClientDriverJettyHandler handler) {
        this.handler = handler;
        this.portNum = ClientDriver.getFreePort();
        this.jettyServer = new Server(this.portNum);
        this.startJetty();
    }

    public ClientDriver(ClientDriverJettyHandler handler, int port) {
        this.portNum = port;
        this.handler = handler;
        this.jettyServer = new Server(this.portNum);
        this.startJetty();
    }

    private void startJetty() {
        try {
            this.jettyServer.setHandler(this.handler.getJettyHandler());
            this.jettyServer.start();
        }
        catch (Exception e) {
            throw new ClientDriverSetupException("Error starting jetty on port " + this.portNum, e);
        }
    }

    public String getBaseUrl() {
        return "http://localhost:" + this.portNum;
    }

    public static int getFreePort() {
        try {
            ServerSocket server = new ServerSocket(0);
            int port = server.getLocalPort();
            server.close();
            return port;
        }
        catch (IOException ioe) {
            throw new ClientDriverSetupException("IOException finding free port", ioe);
        }
    }

    public void shutdown() {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            throw new ClientDriverFailedExpectationException("Error shutting down jetty", e);
        }
        this.verify();
    }

    public void addExpectation(ClientDriverRequest request, ClientDriverResponse response) {
        this.handler.addExpectation(request, response);
    }

    private void verify() {
        this.handler.checkForUnexpectedRequests();
        this.handler.checkForUnmatchedExpectations();
    }
}

