/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class ClientDriverRequest {
    private final Object path;
    private final Map<String, Object> params;
    private final Map<String, Object> headers;
    private Method method;
    private Object bodyContent;
    private Object bodyContentType;

    public ClientDriverRequest(String path) {
        this.path = path;
        this.method = Method.GET;
        this.params = new HashMap<String, Object>();
        this.headers = new HashMap<String, Object>();
    }

    public ClientDriverRequest(Pattern path) {
        this.path = path;
        this.method = Method.GET;
        this.params = new HashMap<String, Object>();
        this.headers = new HashMap<String, Object>();
    }

    public Object getPath() {
        return this.path;
    }

    public ClientDriverRequest withMethod(Method withMethod) {
        this.method = withMethod;
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public ClientDriverRequest withParam(String key, String value) {
        this.params.put(key, value);
        return this;
    }

    public ClientDriverRequest withParam(String key, Pattern value) {
        this.params.put(key, value);
        return this;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String toString() {
        return "ClientDriverRequest: " + (Object)((Object)this.method) + " " + this.path.toString() + "; ";
    }

    public Object getBodyContent() {
        return this.bodyContent;
    }

    public Object getBodyContentType() {
        return this.bodyContentType;
    }

    public ClientDriverRequest withBody(String withBodyContent, String withContentType) {
        this.bodyContent = withBodyContent;
        this.bodyContentType = withContentType;
        return this;
    }

    public ClientDriverRequest withBody(String withBodyContent, Pattern contentType) {
        this.bodyContent = withBodyContent;
        this.bodyContentType = contentType;
        return this;
    }

    public ClientDriverRequest withBody(Pattern withBodyContent, String contentType) {
        this.bodyContent = withBodyContent;
        this.bodyContentType = contentType;
        return this;
    }

    public ClientDriverRequest withBody(Pattern withBodyContent, Pattern contentType) {
        this.bodyContent = withBodyContent;
        this.bodyContentType = contentType;
        return this;
    }

    public ClientDriverRequest withHeader(String withHeaderName, String withHeaderValue) {
        this.headers.put(withHeaderName, withHeaderValue);
        return this;
    }

    public ClientDriverRequest withHeader(String withHeaderName, Pattern withHeaderValue) {
        this.headers.put(withHeaderName, withHeaderValue);
        return this;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public static enum Method {
        GET,
        POST,
        PUT,
        DELETE,
        OPTIONS,
        HEAD;

    }
}

