/*
 * Decompiled with CFR 0.152.
 */
package com.github.restdriver.clientdriver;

import java.util.HashMap;
import java.util.Map;

public final class ClientDriverResponse {
    private static final int DEFAULT_STATUS_CODE = 200;
    private int status;
    private final String content;
    private String contentType;
    private final Map<String, String> headers;

    public ClientDriverResponse() {
        this("");
    }

    public ClientDriverResponse(String content) {
        this.content = content;
        this.status = 200;
        this.contentType = "text/plain";
        this.headers = new HashMap<String, String>();
    }

    public String getContent() {
        if (this.content == null) {
            return "";
        }
        return this.content;
    }

    public ClientDriverResponse withStatus(int withStatus) {
        this.status = withStatus;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ClientDriverResponse withContentType(String withContentType) {
        this.contentType = withContentType;
        return this;
    }

    public ClientDriverResponse withHeader(String name, String value) {
        this.headers.put(name, value);
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

